#include "blue-dream.h"

t_dword get_ecco_world_property(int id, int type)
{
	t_dword table[] = {

		// PALETTE

		0x728e8, // HOMEBAY
		0xbf69a, // HARDWATER
		0xacc86, // CITYOFFOREVER
		0x9246a, // JURASSICBEACH
		0xa69da  // THEMACHINE
	};

	return table[id + type];
}

t_dword get_ecco_stage_property(int id, int type)
{
	t_dword table[] = {

		// EC_WORLD

		EC_WORLD_HOMEBAY, // HOMEBAY
		EC_WORLD_HOMEBAY, // UNDERCAVES
		EC_WORLD_HOMEBAY, // THEVENTS
		EC_WORLD_HOMEBAY, // THELAGOON
		EC_WORLD_HOMEBAY, // ISLANDZONE
		EC_WORLD_HOMEBAY, // RIDGEWATER
		EC_WORLD_HOMEBAY, // DEEPWATER
		EC_WORLD_HOMEBAY, // MEDUSABAY
		EC_WORLD_HOMEBAY, // OPENOCEAN
		EC_WORLD_HOMEBAY, // SELECTIONSCR
		EC_WORLD_HOMEBAY, // ATTRACTMODE
		EC_WORLD_HOMEBAY, // CELEBRATION

		EC_WORLD_JURASSICBEACH, // JURASSICBEACH
		EC_WORLD_JURASSICBEACH, // PTERANODONPOND
		EC_WORLD_JURASSICBEACH, // ORIGINBEACH
		EC_WORLD_JURASSICBEACH, // TRILOBITECIRCLE
		EC_WORLD_JURASSICBEACH, // DARKWATER

		EC_WORLD_THEMACHINE,    // THEMACHINE
		EC_WORLD_THEMACHINE,    // THETUBE
		EC_WORLD_THEMACHINE,    // RETURNTOEARTH

		EC_WORLD_CITYOFFOREVER, // DEEPCITY
		EC_WORLD_CITYOFFOREVER, // THEMARBLESEA
		EC_WORLD_CITYOFFOREVER, // THELIBRARY
		EC_WORLD_CITYOFFOREVER, // CITYOFFOREVER

		EC_WORLD_HARDWATER, // COLDWATER
		EC_WORLD_HARDWATER,     // HARDWATER
		EC_WORLD_HARDWATER,     // ICEZONE

		EC_WORLD_THEMACHINE,    // THELASTFIGHT

		// EC_NAMETABLE_ATTRIBUTE_OFFSETS

		0x73a72, // HOMEBAY
		0x73a9a, // UNDERCAVES
		0x73ac2, // THEVENTS
		0x73aea, // THELAGOON
		0x73b12, // ISLANDZONE
		0x73b3a, // RIDGEWATER
		0x73b62, // DEEPWATER
		0x73b8a, // MEDUSABAY
		0x73bb2, // OPENOCEAN
		0x73bda, // SELECTIONSCR
		0x73c02, // ATTRACTMODE
		0x73c2a, // CELEBRATION
		0x93528, // JURASSICBEACH
		0x93550, // PTERANODONPOND
		0x93578, // ORIGINBEACH
		0x935a0, // TRILOBITECIRCLE
		0x935c8, // DARKWATER
		0xa6b12, // WELCOMETOTHEMACHINE
		0xa6b3a, // THETUBE
		0xa6b62, // RETURNTOEARTH
		0xadeac, // DEEPCITY
		0xaded4, // THEMARBLESEA
		0xadefc, // THELIBRARY
		0xadf24, // CITYOFFOREVER
		0xc0776, // COLDWATER
		0xc079e, // HARDWATER
		0xc07c6, // ICEZONE
		0xca6fe  // THELASTFIGHT
	};

	return table[id + type];
}

t_unicode *get_ecco_stage_save_state(int id)
{
	const char *table[] = {
		"HOMEBAY.gsx",
		"UNDERCAVES.gsx",
		"THEVENTS.gsx",
		"THELAGOON.gsx",
		"ISLANDZONE.gsx",
		"RIDGEWATER.gsx",
		"DEEPWATER.gsx",
		"MEDUSABAY.gsx",
		"OPENOCEAN.gsx",
		"SELECTIONSCR.gsx",
		"ATTRACTMODE.gsx",
		"CELEBRATION.gsx",
		"JURASSICBEACH.gsx",
		"PTERANODONPOND.gsx",
		"ORIGINBEACH.gsx",
		"TRILOBITECIRCLE.gsx",
		"DARKWATER.gsx",
		"WELCOMETOTHEMACHINE.gsx",
		"THETUBE.gsx",
		"RETURNTOEARTH.gsx",
		"DEEPCITY.gsx",
		"THEMARBLESEA.gsx",
		"THELIBRARY.gsx",
		"CITYOFFOREVER.gsx",
		"COLDWATER.gsx",
		"HARDWATER.gsx",
		"ICEZONE.gsx",
		"THELASTFIGHT.gsx"
	};

	return copy_append_string(
		"data/ECCO_US_OCT_1992/", table[id]);
}

t_dword get_ecco_nametable_attribute(
	t_byte *rom,
	int offset,
	int id)
{
	t_dword table[EC_NAMETABLE_ATTRIBUTE_TOTAL];

	table[EC_FOREGROUND_W] = unpack_word(rom, offset + 0x0);
	table[EC_FOREGROUND_H] = unpack_word(rom, offset + 0x2);
	table[EC_FG_NAMETABLE_OFFSET] = unpack_dword(rom, offset + 0x8);

	table[EC_BACKGROUND_W] = unpack_word(rom, offset + 0x10);
	table[EC_BACKGROUND_H] = unpack_word(rom, offset + 0x12);
	table[EC_PALETTEROWATTRIBUTE_OFFSET] = unpack_dword(rom, offset + 0x14);
	table[EC_BG_NAMETABLE_OFFSET] = unpack_dword(rom, offset + 0x18);

	return table[id];
}