﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Imaging;

namespace E2ED
{
    public partial class Form1 : Form
    {
        private Dictionary<int, Bitmap> SonarImages;

        #region variables added by Vile1101
        
        // this is a collection of all the tiles in the current tileset. I'm identifying the images by their name in the resource file,
        // but you could probably do better
        private Dictionary<short, Bitmap> []tileImages;

        // since the tiles in the tileset are drawn to a single image, this lets us know where each tile is located so that when the user clicks
        // on a tile on the left panel, we'll know what tile they clicked on.
        private Dictionary<Rectangle, short> tileLocations;

        private short selectedTile = 0;

        // the first pair of bitmaps is for showing the available tiles, the second pair of bitmaps is for the actual level. 
        // by using two bitmaps, one for the entire image and one for just the visible portion, we get a significant speed increase.

        private Bitmap tileSetImage; // image which contains all the tiles in the tile set
        private Bitmap tileSetViewableImage; // image which contains the section of tileSetImage which is visible at the time

        private Bitmap levelImage; // image of the entire level
        private Bitmap levelViewableImage; // image of the section of levelImage which is visible at the time

        // end of new declarations
        #endregion

        int i, j, k, l, m, n;                 //General purpose indexers
        int temp0, temp1, temp2, temp3;              
        short work;                           //General purpose variables

        int a, r, g, b;                       //Pallete color components

        int filesize;                         //Filesize of file to determine if it is a SState or a RDump

        #region Selected level vars
        string Levelname;
        int ThisLevelIndex;
        int ThisLevelGroup;
        int ThisLevelOffset;
        #endregion

        bool AdvancedEditor = false;
        public static bool NewObjectExtractingMethod = true;

        bool collisionON = true;
        bool objectsON = true;
        bool backgroundON = false;
        bool foregroundON = true;
        bool Special_Levels_already_loaded = false;

        public enum CurrentOppened
        {
            RAMdump = 0,
            SaveState = 0,
            ROM = 1
        }
        public static CurrentOppened Last_File_Opened;

        public enum EccoVersions
        {
            _E2A = 0,
            _X11,
            _429,
            _E2J,
            _E2E,
            _E2U,
            _E2JR_F,
            _E2JR_M
        }
        public static EccoVersions ROMversion, RAMversion;

        int []levelpointerlist = { 0x00075040, 0x0008C5A0, 0x0008EA84, 0x0008DA32, 0x00018060, 0x0008D83E, 0x0008FB52, 0x0008FAC0 };
        int[] bosshead_PRIM_loc = { 0x0016A578, 0x001C1030, 0x001C9BB4, 0x001C3A8C, 0x001BE05C, 0x001C2AC8, 0x7FFFFFFF, 0x7FFFFFFF };
        int[] unver1_logo_PRIM_loc = { 0x001620E8, 0x001BA4DC, 0x001C3060, 0x001BDB34, 0x001B522C, 0x001BD7FC, 0x7FFFFFFF, 0x7FFFFFFF };
        int []subroutine_compare = { 0x000B66B0, 0x000E5878, 0x000E9AE0, 0x000EC42C, 0x000E3BB0, 0x000EC0FC, 0x000AC4A2, 0x000AC288 };
        int []RamVariables = { 0x00000000, 0x0000DC9C, 0x00000000, 0x00000000, 0x0000D4B4, 0x0000DCBC, 0x00000000, 0x00000000 };
        int []ObjSizeTable = { 0x0000483E, 0x000044FA, 0x00004506, 0x00000000, 0x0000419A, 0x0000419A, 0x00000000, 0x00000000 };
        int pointer_find_window_size = 0x0300;

        //This was very tedious to do, and is still a work-in-progress, almost useless now, though
        //                       0   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F
        byte[] object_sizes = { 05, 05, 05, 05, 04, 04, 00, 07, 07, 04, 04, 04, 04, 04, 05, 05, //00-0F
                                05, 06, 07, 05, 05, 04, 05, 06, 04, 05, 04, 00, 05, 08, 00, 00, //10-1F
                                00, 09, 09, 08, 00, 07, 06, 00, 06, 05, 06, 06, 00, 00, 04, 08, //20-2F
                                05, 06, 05, 06, 06, 06, 06, 07, 00, 00, 00, 04, 06, 00, 00, 04, //30-3F
                                05, 05, 00, 09, 00, 00, 00, 06, 07, 00, 00, 04, 05, 07, 06, 07, //40-4F
                                00, 04, 00, 05, 05, 07, 07, 00, 07, 00, 05, 05, 06, 07, 07, 05, //50-5F
                                00, 07, 00, 00, 05, 06, 06, 06, 06, 00, 10, 08, 00, 00, 06, 00, //60-6F
                                05, 06, 07, 05, 07, 07, 06, 05, 06, 04, 04, 05, 05, 05, 00, 00, //70-7F
                                00, 00, 05, 00, 04, 00, 00, 00, 05, 06, 04, 05, 06, 05, 05, 07, //80-8F
                                07, 07, 08, 04, 05, 05, 05, 06, 00, 04, 06, 06, 05, 05, 00, 00, //90-9F
                                00, 00, 07, 00, 07, 06, 00, 00, 00, 05, 07, 00, 05, 00, 06, 08, //A0-AF
                                07, 07, 00, 00, 00, 00, 00, 07, 07, 06, 00, 06, 03, 00, 05, 00, //B0-BF
                                00, 05, 05, 06, 07, 05, 04, 06, 05, 04, 05, 05, 00, 04, 03, 05, //C0-CF
                                04, 00, 06, 04, 00, 00, 04, 04, 04, 00, 00, 00, 00, 00, 00, 00, //D0-DF
                                00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, //E0-EF
                                00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, 00, //F0-FF
                              };//   1   2   3   4   5   6   7   8   9   A   B   C   D   E   F



        #region Open/Save file dialogs
        OpenFileDialog OpenEccoROM;
        OpenFileDialog OpenEccoState;
        SaveFileDialog SaveRawMAP;
        SaveFileDialog LevelPIC;
        #endregion

        #region Program sub-windows
        LevelProperties LevelOptions;
        E2ED_Conf ConfigurationWindow;
        ErrorPopup ErrorWinn;
        VersionPopup ROMver, RAMver;

        #endregion

        NumericUpDown[] Obj_Parameters;
        Label[] Parameter_Description;
        Point ClickedLocation;

        #region File handlers
        FileInfo EccoROM;
        FileInfo EccoSS;
        FileStream EccoROMstream;
        FileStream EccoSSstream;
        BinaryReader ROMbuf;
        BinaryReader buf;
        #endregion

        public Color BGColor;
        public Color[] pallete;
        public short[] palleteRAW;
        bool shadow_bit;

        public Bitmap[] VramArrayBitmap;
        public int [] Vram;
        public uint[] VramTileLocations; 

        int [][]Raw128x128pixels;
        Bitmap [][]Blockimages;
        Bitmap [][]SpecialBlockImages;
        Bitmap SelectedImage = null;

        int []pointerliste;
        int Level_variablesloc;


        Size PanelSize;
        Size OriginalPanelSize;


        #region Decompressor Vars
        //-------------Decompressor Variables:
        
        byte [] primary_decompression_buffer;
        byte [] secondary_decompression_buffer;
        int buffer_offset = 4092;
        int stored_size;
        short operator_;
        int operator_offset;
        int repeat_counter;
        byte key;
        bool key_bit;
        byte next_key_distance = 0;

        //------------------------------------
        #endregion

        #region Loaded level map attributes
        short [][] foregroundmap;
        short [][] backgroundmap;
        byte [][][] objmap;
        public struct Secondary_Layout
        {
            public int number_of_elements;
            public short[] overlay_map;
        }
        public Secondary_Layout [][]FGmap_secondary;
        public Secondary_Layout [][]BGmap_secondary;

        int objectmaploc;
        int objectlistloc;
        int FGmaploc;
        int BGmaploc;
        short FGwidth = 8;
        short FGheight = 8;
        short BGwidth = 8;
        short BGheight = 8;
        #endregion

        #region Level (groups or single levels) headers variables
        public struct LevelPrimitives
        {
            public int VDPregs;
            public short VramFontTiles;
            public short WindowMappingMask;
            public short FontColors;
            public short VramSpriteTiles;
            public short unknownLP_4;
            public int Palletes;
            public int unknownLP_5;
            public int Tiles;
            public int MiscObjectsTiles;
            public int SpecialBlocks;
            public int unknwonLP_6;
            public int unknownLP_7;
            public int unknownLP_8;
            public int LVLgroup;
            public int unknownLP_9;
            public int unkwnonLP_10;
        }       LevelPrimitives [] LVLPrims;

        public struct LevelGroup
        {
            public int ROM_OBJlist;
            public int ROM_OBJmap;
            public short ROM_FGwidth;
            public short ROM_FGheight;
            public short ROM_Xstart;
            public short ROM_Ystart;
            public int ROM_FGlayout;
            public int ROM_Compressed128;
            public short ROM_BGwidth;
            public short ROM_BGheight;
            public int ROM_LVheader;
            public int ROM_BGlayout;
            public short ROM_Xviewable;
            public short ROM_Yviewable;
        }        LevelGroup [][] A;

        public struct Level
        {
            public byte EccoAngle;
            public int BGscroll;
            public byte HIpriority;
            public byte MusicID;
            public byte WaterLevel;
            public short unknownLV0;
            public short unknownLV1;
            public short unknownLV2;
            public bool moon;
            public byte Y0;
            public byte P0;
            public byte Y1;
            public byte P1;
            public byte Y2;
            public byte P2;
            public byte Y3;
            public byte P3;
            public int unused0;
            public int unused1;
            public string Levelname;
        }       Level []level;

        short[] LevelGroup_contained_levels;
        int[] LevelGroup128ptrs;
        int[] LevelGroup128ptrs_copy;
        int[][] LevelGroup128blocs;
        short[] map_128x128;
        short[][][] map_special;
        int special_block_index;

        int[] ptrs_128x128;
        int[] ptrs_SpecialBlocks;
        int first_uncompressed_block_ptr;
        int num_of_128blocks;
        int num_of_compressed_128_blocks;
        int num_of_uncompressed_128_blocks;
        int[] index_map_of_compressed128;
        int[] index_map_of_uncompressed128;
        int true_num_of_128blocks;
        int number_of_LVLgroups;
        short[] TotalPalletes;
        int TotalLevels;
        int [][]pointers;
        #endregion

        //END of variables


        public Form1()
        {
            SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            InitializeComponent();
        }

        #region Endian-ness correction functions
        public int Int32Swap(int Littleendian)
        {
            byte byte1, byte2, byte3, byte4;
            byte1 = (byte) (Littleendian & 0xFF);
            byte2 = (byte) (( Littleendian >> 8 ) & 0xFF);
            byte3 = (byte) (( Littleendian >>16 ) & 0xFF);
            byte4 = (byte) (( Littleendian >>24 ) & 0xFF);
            return ((int) byte1 << 24) | 
                   ((int) byte2 << 16) |
                   ((int) byte3 << 8) |
                   (int) byte4;
        }

        public short Int16Swap(short Littleendian)
        {
            byte byte1, byte2;
            byte1 = (byte) ( Littleendian & (short)0xFF );
            byte2 = (byte) (( Littleendian >> 8 ) & 0xFF );
            return (short)((((short)byte1) << (short)8) |
                   (short)byte2);
        }
        #endregion

        /// <summary>
        /// Code made by tails slightly modified 
        /// Decompressor of type #2
        /// </summary>
        /// <param name="addr"></param>
        /// <param name="offs"></param>
        /// <returns></returns>
        public byte[] DecompressBlock(long addr, int offs)
        {
            ROMbuf.BaseStream.Seek(addr + offs, SeekOrigin.Begin);
            byte[] block = new byte[512];
            byte copy_byte = 0;
            sbyte control_byte = -1;
            for (int i = 0; i < 2; ++i)
            {
                control_byte = -1;
                for (int j = i; j < 512; j += 2)
                {
                    control_byte = (sbyte)(ROMbuf.ReadByte());
                    if (control_byte < 0)
                    {
                        copy_byte = (byte)(ROMbuf.ReadByte());
                        while (j < 512 && control_byte < 1)
                        {
                            ++control_byte;
                            block[j] = copy_byte;
                            j += 2;
                        }
                        j -= 2;
                    }
                    else
                    {
                        while (control_byte >= 0 && j < 512)
                        {
                            --control_byte;
                            block[j] = (byte)(ROMbuf.ReadByte());
                            j += 2;
                        }
                        j -= 2;
                    }
                }
            }
            return block;
        }

        public Bitmap CreateBitmapFromTile(short Tilemap, int Pallete_Index, bool FGon)
        {
            Bitmap TileBitmap = new Bitmap(8, 8, PixelFormat.Format32bppArgb);
            uint a, r, g, b, row, pixel;
            int i, j, PalSelect, ColorIndex;
            int []RawPixels = new int[8];
            int[][] RawBitmap = new int[8][];
            int FlipV_FlipH;

            Rectangle Rect = new Rectangle(0, 0, 8, 8);
            BitmapData _BitmapData;
            IntPtr pointer;

            FlipV_FlipH = (Tilemap >> 11) & 0x0003;
            PalSelect = (Tilemap >> 9) & 0x0030;
            for (i = 0; i < 8; i++)
                RawBitmap[i] = new int[8];
            for (i = 0; i < 8; i++)
            {
                
                RawPixels[i] = Vram[((Tilemap & 0x07FF) << 3) + i];
                row = (uint)RawPixels[i];
                
                for (j = 0; j < 8; j++)
                {
                    ColorIndex = ((int)row & 0x0000000F);
                    a = 255;
                    if (ColorIndex == 0 && FGon)
                        a = 0;
                    r = (uint)((palleteRAW[(Pallete_Index << 6) + PalSelect + ColorIndex] & 0x000F) * 18);
                    g = (uint)(((palleteRAW[(Pallete_Index << 6) + PalSelect + ColorIndex] & 0x00F0) >> 4) * 18);
                    b = (uint)(((palleteRAW[(Pallete_Index << 6) + PalSelect + ColorIndex] & 0x0F00) >> 8) * 18);

                    //shadow tile if map prority is low and if is enabled in the VDP
                    if (((Tilemap & 0x8000) == 0000) && shadow_bit && FGon)
                    {
                        r = r >> 1;
                        g = g >> 1;
                        b = b >> 1;
                    }
                    
                    row = row >> 4;
                    pixel = (a << 24) | (r << 16) | (g << 8) | (b);
                    RawBitmap[i][j] = (int)pixel;
                }
            }
            int[] RawBitmap2 = RawBitmap.SelectMany(x => x).ToArray();
            _BitmapData = TileBitmap.LockBits(Rect, System.Drawing.Imaging.ImageLockMode.ReadWrite, TileBitmap.PixelFormat);
            pointer = _BitmapData.Scan0;
            System.Runtime.InteropServices.Marshal.Copy(RawBitmap2, 0, pointer, 64);
            TileBitmap.UnlockBits(_BitmapData);
            switch (FlipV_FlipH)
            {
                case 3: TileBitmap.RotateFlip(RotateFlipType.RotateNoneFlipY);
                    break;
                case 2: TileBitmap.RotateFlip(RotateFlipType.RotateNoneFlipXY);
                    break;
                case 1: 
                    break;
                default: TileBitmap.RotateFlip(RotateFlipType.RotateNoneFlipX);
                    break;
            }
            return TileBitmap;
        }

        public Bitmap Create_colision_rectangle(int width, int height)
        {
            Graphics G;
            Bitmap A = new Bitmap(width, height, PixelFormat.Format32bppArgb);
            Pen pen = new Pen(Color.FromArgb(-0xFF01), 2); //FFFF00FF
            Rectangle rect = new Rectangle(1, 1, width - 2, height - 2);
            G = Graphics.FromImage(A);
            G.DrawRectangle(pen, rect);
            return A;
        }

        public Bitmap Create_colision_triangle(int type)
        {
            Graphics G;
            Bitmap A = new Bitmap(128, 128, PixelFormat.Format32bppArgb);
            Pen Thinpen = new Pen(Color.FromArgb(-0xFFFF01 - 0xFF), 1); //FFFF00FF
            Pen Thickpen = new Pen(Color.FromArgb(-0xFF01), 2); //FFFF00FF
            Point []Tri_Vertices = new Point[3];
            G = Graphics.FromImage(A);
            //Awful coding but this is how I came up with
            switch (type)
            {
                case 0:
                    Tri_Vertices[0].X = 127;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 0;
                    Tri_Vertices[2].Y = 127;

                    break;
                case 1:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 63;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 0;
                    break;
                case 2:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 127;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 63;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 63;
                    break;
                case 3:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 127;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 63;
                    Tri_Vertices[2].Y = 0;
                    break;
                case 4:
                    Tri_Vertices[0].X = 63;
                    Tri_Vertices[0].Y = 127;
                    Tri_Vertices[1].X = 63;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 0;
                    break;
                case 5:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 127;
                    break;
                case 6:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 63;
                    break;
                case 7:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 63;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 63;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 127;
                    break;
                case 8:
                    Tri_Vertices[0].X = 63;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 127;
                    break;
                case 9:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 63;
                    Tri_Vertices[1].Y = 0;
                    Tri_Vertices[2].X = 63;
                    Tri_Vertices[2].Y = 127;
                    break;
                case 10:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 127;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 0;
                    break;
                case 11:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 63;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 63;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 0;
                    break;
                case 12:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 127;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 63;
                    break;
                case 13:
                    Tri_Vertices[0].X = 63;
                    Tri_Vertices[0].Y = 127;
                    Tri_Vertices[1].X = 127;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 0;
                    break;
                case 14:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 127;
                    Tri_Vertices[1].X = 63;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 63;
                    Tri_Vertices[2].Y = 0;
                    break;
                case 15:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 127;
                    break;
                case 16:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 63;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 63;
                    break;
                case 17:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 63;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 127;
                    break;
                case 18:
                    Tri_Vertices[0].X = 0;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 0;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 63;
                    Tri_Vertices[2].Y = 127;
                    break;
                case 19:
                    Tri_Vertices[0].X = 63;
                    Tri_Vertices[0].Y = 0;
                    Tri_Vertices[1].X = 63;
                    Tri_Vertices[1].Y = 127;
                    Tri_Vertices[2].X = 127;
                    Tri_Vertices[2].Y = 127;
                    break;
                default:
                    richTextBox1.Text += "Unknown collision block: " + type.ToString() + "\n";
                    return A;
            }
            G.DrawLines(Thinpen, Tri_Vertices);
            G.DrawLine(Thickpen, Tri_Vertices[2], Tri_Vertices[0]);
            return A;
        }

        public void Draw_Colison_Shapes()
        {
            int x, y, X, Y; //define the viewable portion on the full layout
            int a, b, c, d; //looping variables
            int width, height; //Collision block dimensions
            int X_pos, Y_pos;  //Collision block positioning
            Rectangle Src, Dst;
            Bitmap Collisionsketch;
            Src = new Rectangle(0, 0, 128, 128);
            Dst = new Rectangle(0, 0, 128, 128);
            x = LevelScrollBar_H.Value >> 7;
            y = LevelScrollBar_V.Value >> 7;
            X = x + (pnlLevel.Width >> 7);
            Y = y + (pnlLevel.Height >> 7);
            if (objmap == null)
            {
                collisionON = !collisionON;
                collisionToolStripMenuItem.Checked = false;
                return;
            }
            //Scan through the object map, in the shown area locations
            for (a = y; a <= Y + 1; a++)
            {
                if (a >= objmap.Length)
                    break;
                for (b = x; b <= X + 1; b++)
                {
                    if (b >= objmap[a].Length)
                        break;
                    d = 1;
                    if (objmap[a][b] == null)
                        continue;
                    for (c = 0; c < objmap[a][b][0]; c++)
                    {
                        if (((objmap[a][b][d] & 0xFC) == 0x00))
                        {
                            width = (((objmap[a][b][d + 4] >> 4) & 0x0F) + 1) << 3;
                            height = ((objmap[a][b][d + 4] & 0x0F) + 1) << 3;

                            X_pos = (((objmap[a][b][d + 3] >> 4) & 0x0F) << 3) - (LevelScrollBar_H.Value & 0xFFFF);
                            Y_pos = ((objmap[a][b][d + 3] & 0x0F) << 3) - (LevelScrollBar_V.Value & 0xFFFF);

                            Src = new Rectangle(0, 0, width, height);
                            Dst = new Rectangle((b << 7) + X_pos, (a << 7) + Y_pos, width, height);

                            Collisionsketch = (Bitmap)(Create_colision_rectangle(width, height));
                            CopyImageRegion(Collisionsketch, levelViewableImage, Src, Dst);
                            Collisionsketch.Dispose();
                        }
                        if (objmap[a][b][d] == 0x04)
                        {
                            switch (objmap[a][b][d + 3] & 0xF0)
                            {
                                case (0x00):
                                    width = 8;
                                    height = 128;
                                    X_pos = 0 + ((objmap[a][b][d + 3] & 0x0F) << 3) - (LevelScrollBar_H.Value & 0xFFFF);
                                    Y_pos = 0 - (LevelScrollBar_V.Value & 0xFFFF);
                                    break;
                                case (0x10):
                                    width = 8;
                                    height = 128;
                                    X_pos = 120 - ((objmap[a][b][d + 3] & 0x0F) << 3) - (LevelScrollBar_H.Value & 0xFFFF);
                                    Y_pos = 0 - (LevelScrollBar_V.Value & 0xFFFF);
                                    break;
                                case (0x20):
                                    width = 128;
                                    height = 8;
                                    X_pos = 0 - (LevelScrollBar_H.Value & 0xFFFF);
                                    Y_pos = 120 - ((objmap[a][b][d + 3] & 0x0F) << 3) - (LevelScrollBar_V.Value & 0xFFFF);
                                    break;
                                case (0x30):
                                    width = 128;
                                    height = 8;
                                    X_pos = 0 - (LevelScrollBar_H.Value & 0xFFFF);
                                    Y_pos = 0 + ((objmap[a][b][d + 3] & 0x0F) << 3) - (LevelScrollBar_V.Value & 0xFFFF);
                                    break;
                                default:
                                    richTextBox1.Text += "Unknown collision type 4\n";
                                    continue;
                            }

                            Src = new Rectangle(0, 0, width, height);
                            Dst = new Rectangle((b << 7) + X_pos, (a << 7) + Y_pos, width, height);

                            Collisionsketch = (Bitmap)(Create_colision_rectangle(width, height));
                            CopyImageRegion(Collisionsketch, levelViewableImage, Src, Dst);
                            Collisionsketch.Dispose();
                        }
                        if (objmap[a][b][d] == 0x05)
                        //Diagonal collison block
                        {
                            Src = new Rectangle(0, 0, 128, 128);
                            Dst = new Rectangle((b << 7) - LevelScrollBar_H.Value, (a << 7) - LevelScrollBar_V.Value, 128, 128);

                            Collisionsketch = (Bitmap)(Create_colision_triangle(objmap[a][b][d + 3]));
                            CopyImageRegion(Collisionsketch, levelViewableImage, Src, Dst);
                            Collisionsketch.Dispose();
                        }
                        if (object_sizes[objmap[a][b][d]] == 0)
                            break;
                        d += object_sizes[objmap[a][b][d]];
                    }
                }
            }
        }

        public void loadEcco2ROMToolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.Text = richTextBox1.Text + "Load Ecco 2 ROM file... \n";
            OpenEccoROM = new OpenFileDialog();
            OpenEccoROM.Filter = "Ecco 2 ROMs|*ecco*.bin";
            if (OpenEccoROM.ShowDialog(this) == System.Windows.Forms.DialogResult.OK)
            {
                if (ROMbuf != null)
                {
                    EccoROMstream.Close();
                    ROMbuf.Close();
                    comboBox1.Items.Clear();

                    pointer_find_window_size = 0x0300;
                    Special_Levels_already_loaded = false;
                }

                Last_File_Opened = CurrentOppened.ROM;
                EccoROM = new FileInfo(OpenEccoROM.FileName);
                richTextBox1.Text += "Opened " + '"' + OpenEccoROM.FileName + '"' + "\n";
                pointerliste = new int[16];
                Special_Levels_already_loaded = false;
                
                //Manual Version selection (better than noth)
                ROMver = new VersionPopup();
                ROMver.ShowDialog();
                ROMver.Dispose();


                EccoROMstream = EccoROM.Open(FileMode.Open, FileAccess.Read);
                ROMbuf = new BinaryReader(EccoROMstream);
               
                //Get object list sizes from the ROM
                if (ObjSizeTable[(int)ROMversion] != 0)
                {
                    ROMbuf.BaseStream.Seek(ObjSizeTable[(int)ROMversion] + 12, SeekOrigin.Begin);
                    for (i = 0; i < 256; i++)
                    {
                        object_sizes[i] = ROMbuf.ReadByte();
                        ROMbuf.BaseStream.Seek(31, SeekOrigin.Current);
                    }
                }


                //Fseek into master pointers
                ROMbuf.BaseStream.Seek(levelpointerlist[(int)ROMversion], SeekOrigin.Begin);

                //Search pointers for the levelgroup master headers
                i = 0;
                while (pointer_find_window_size > 0)
                {
                        if (Int32Swap(ROMbuf.ReadInt32()) == 0x2F004879)
                        {
                            ROMbuf.BaseStream.Seek(4, SeekOrigin.Current);
                            if (Int16Swap(ROMbuf.ReadInt16()) == (short)0x4EB9)
                            {
                                if (Int32Swap(ROMbuf.ReadInt32()) == subroutine_compare[(int)ROMversion])
                                {
                                    
                                    ROMbuf.BaseStream.Seek(-10, SeekOrigin.Current);
                                    pointerliste[i] = Int32Swap(ROMbuf.ReadInt32());
                                    #region Special cases for Unver1, logo and bosshead
                                    if (((pointerliste[i] > unver1_logo_PRIM_loc[(int)ROMversion]) || (pointerliste[i] > bosshead_PRIM_loc[(int)ROMversion])) && !Special_Levels_already_loaded)
                                    {
                                        pointerliste[i + 2] = pointerliste[i];
                                        pointerliste[i] = unver1_logo_PRIM_loc[(int)ROMversion];
                                        richTextBox1.Text += "Manually added:" + i.ToString() + ": 0x" + pointerliste[i].ToString("X").PadLeft(8, '0') + "\n";
                                        i++;
                                        pointerliste[i] = bosshead_PRIM_loc[(int)ROMversion];
                                        richTextBox1.Text += "Manually added:" + i.ToString() + ": 0x" + pointerliste[i].ToString("X").PadLeft(8, '0') + "\n";
                                        i++;
                                        Special_Levels_already_loaded = true;
                                    }
                                    #endregion
                                    pointer_find_window_size -= 30;
                                    ROMbuf.BaseStream.Seek(16, SeekOrigin.Current);
                                    richTextBox1.Text += i.ToString() + ": 0x" + (pointerliste[i].ToString("X").PadLeft(8, '0')) + "\n";
                                    i++;
                                    continue;
                                }
                            }
                        }
                    ROMbuf.BaseStream.Seek(-2, SeekOrigin.Current);
                    pointer_find_window_size -= 2;
                }

                #region Get bosshead if it is after everything, like in E2A
                if (!Special_Levels_already_loaded)
                {
                    pointerliste[i] = unver1_logo_PRIM_loc[(int)ROMversion];
                    richTextBox1.Text += "Manually added:" + i.ToString() + ": 0x" + pointerliste[i].ToString("X").PadLeft(8, '0') + "\n";
                    i++;
                    pointerliste[i] = bosshead_PRIM_loc[(int)ROMversion];
                    richTextBox1.Text += "Manually added:" + i.ToString() + ": 0x" + pointerliste[i].ToString("X").PadLeft(8, '0') + "\n";
                    i++;
                    Special_Levels_already_loaded = true;
                }
                #endregion
                if (bosshead_PRIM_loc[(int)ROMversion] == 0x7FFFFFFF)
                    i--;
                if (unver1_logo_PRIM_loc[(int)ROMversion] == 0x7FFFFFFF)
                    i--;

                number_of_LVLgroups = i;

                pointers = new int[number_of_LVLgroups][];
                LVLPrims = new LevelPrimitives[number_of_LVLgroups];
                TotalPalletes = new short[number_of_LVLgroups];
                LevelGroup_contained_levels = new short[number_of_LVLgroups];
                LevelGroup128ptrs = new int[number_of_LVLgroups];
                LevelGroup128blocs = new int[number_of_LVLgroups][];

                for (i = 0; i < number_of_LVLgroups; i++)
                {
                    if (pointerliste[i] == 0)
                        continue;
                    ROMbuf.BaseStream.Seek(pointerliste[i], SeekOrigin.Begin);
                    LVLPrims[i].VDPregs = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].VramFontTiles = Int16Swap(ROMbuf.ReadInt16());
                    LVLPrims[i].WindowMappingMask = Int16Swap(ROMbuf.ReadInt16());
                    LVLPrims[i].FontColors = Int16Swap(ROMbuf.ReadInt16());
                    LVLPrims[i].VramSpriteTiles = Int16Swap(ROMbuf.ReadInt16());
                    LVLPrims[i].unknownLP_4 = Int16Swap(ROMbuf.ReadInt16());
                    LVLPrims[i].Palletes = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].unknownLP_5 = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].Tiles = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].MiscObjectsTiles = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].SpecialBlocks = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].unknwonLP_6 = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].unknownLP_7 = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].unknownLP_8 = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].LVLgroup = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].unknownLP_9 = Int32Swap(ROMbuf.ReadInt32());
                    LVLPrims[i].unkwnonLP_10 = Int32Swap(ROMbuf.ReadInt32());



                    //Calculate the number of palletes in each level group
                    pointers[i] = new int[9];
                    pointers[i][0] = LVLPrims[i].VDPregs;
                    pointers[i][1] = LVLPrims[i].Palletes;
                    pointers[i][2] = LVLPrims[i].unknownLP_5;
                    pointers[i][3] = LVLPrims[i].Tiles;
                    pointers[i][4] = LVLPrims[i].MiscObjectsTiles;
                    pointers[i][5] = LVLPrims[i].SpecialBlocks;
                    pointers[i][6] = LVLPrims[i].unknwonLP_6;
                    pointers[i][7] = LVLPrims[i].unknownLP_7;
                    pointers[i][8] = LVLPrims[i].LVLgroup;
                    Array.Sort(pointers[i]);
                    for (j = 0; j < 9; j++)
                    {
                        if (LVLPrims[i].Palletes == pointers[i][j])
                        {
                            TotalPalletes[i] = (short)((pointers[i][j + 1] - pointers[i][j]) >> 7);
                            break;
                        }
                    }
                }

                A = new LevelGroup[number_of_LVLgroups][];
                k = 0;
                //Retreaving level names
                for (j = 0; j < number_of_LVLgroups; j++)
                {
                    ROMbuf.BaseStream.Seek((long)LVLPrims[j].LVLgroup, System.IO.SeekOrigin.Begin);
                    LevelGroup_contained_levels[j] = Int16Swap(ROMbuf.ReadInt16());
                    richTextBox1.Text += "Obtained " + LevelGroup_contained_levels[j].ToString() + " levels from 0x" + LVLPrims[j].LVLgroup.ToString("X").PadLeft(8, '0') + "\n";
                    A[j] = new LevelGroup[(int)LevelGroup_contained_levels[j]];

                    LevelGroup128ptrs[j] = Int32Swap(ROMbuf.ReadInt32());
                    for (i = 0; i < LevelGroup_contained_levels[j]; i++)
                    {
                        A[j][i].ROM_OBJlist = Int32Swap(ROMbuf.ReadInt32());
                        A[j][i].ROM_OBJmap = Int32Swap(ROMbuf.ReadInt32());
                        A[j][i].ROM_FGwidth = Int16Swap(ROMbuf.ReadInt16());
                        A[j][i].ROM_FGheight = Int16Swap(ROMbuf.ReadInt16());
                        A[j][i].ROM_Xstart = Int16Swap(ROMbuf.ReadInt16());
                        A[j][i].ROM_Ystart = Int16Swap(ROMbuf.ReadInt16());
                        A[j][i].ROM_FGlayout = Int32Swap(ROMbuf.ReadInt32());
                        A[j][i].ROM_Compressed128 = Int32Swap(ROMbuf.ReadInt32());
                        A[j][i].ROM_BGwidth = Int16Swap(ROMbuf.ReadInt16());
                        A[j][i].ROM_BGheight = Int16Swap(ROMbuf.ReadInt16());
                        A[j][i].ROM_LVheader = Int32Swap(ROMbuf.ReadInt32());
                        A[j][i].ROM_BGlayout = Int32Swap(ROMbuf.ReadInt32());
                        A[j][i].ROM_Xviewable = Int16Swap(ROMbuf.ReadInt16());
                        A[j][i].ROM_Yviewable = Int16Swap(ROMbuf.ReadInt16());
                    }
                    
                    // LevelGroup128blocs[j] = new int[(A[j][0].ROM_Compressed128 - LevelGroup128ptrs[j]) / 4];
                    //Add the levels detected to drop-down menu and fill the 128*128 block information
                    for (i = 0; i < LevelGroup_contained_levels[j]; i++, TotalLevels++)
                    {
                        ROMbuf.BaseStream.Seek((long)(A[j][i].ROM_LVheader + 32), SeekOrigin.Begin);
                        if (ROMversion > EccoVersions._E2A)
                        {
                            Levelname = new string(ROMbuf.ReadChars(16));
                            comboBox1.Items.Add("G" + j.ToString() + " - L" + i.ToString() + ": " + Levelname);
                        }
                        else
                            comboBox1.Items.Add("G" + j.ToString() + " - L" + i.ToString() + ": level " + TotalLevels.ToString());

                    }
                   /*
                    * ROMbuf.BaseStream.Seek((long)LevelGroup128ptrs[j], SeekOrigin.Begin);
                    * for (i = 0; i < (A[j][0].ROM_Compressed128 - LevelGroup128ptrs[j]) >> 2; i++)
                    * {
                    *     ROMbuf.BaseStream.Seek((long)(A[j][0].ROM_Compressed128 + 4), SeekOrigin.Begin);
                    *     k = Int32Swap(ROMbuf.ReadInt32());
                    *     ROMbuf.BaseStream.Seek((long)LevelGroup128ptrs[j], SeekOrigin.Begin);
                    *     LevelGroup128blocs[j][i] = Int32Swap(ROMbuf.ReadInt32()) - k;
                    * }
                    */
                }
                level = new Level[TotalLevels];

                for (j = 0; j < number_of_LVLgroups; j++)
                {
                    ROMbuf.BaseStream.Seek((long)LVLPrims[j].LVLgroup, System.IO.SeekOrigin.Begin);
                    for (i = 0; i < LevelGroup_contained_levels[j]; i++, k++)
                    {
                        ROMbuf.BaseStream.Seek((long)A[j][i].ROM_LVheader, SeekOrigin.Begin);
                        level[k].EccoAngle = ROMbuf.ReadByte();
                        level[k].BGscroll = Int32Swap(ROMbuf.ReadInt32());
                        level[k].HIpriority = ROMbuf.ReadByte();
                        level[k].MusicID = ROMbuf.ReadByte();
                        level[k].WaterLevel = ROMbuf.ReadByte();
                        level[k].unknownLV0 = Int16Swap(ROMbuf.ReadInt16());
                        level[k].unknownLV1 = Int16Swap(ROMbuf.ReadInt16());
                        level[k].unknownLV2 = Int16Swap(ROMbuf.ReadInt16());
                        level[k].moon = !(ROMbuf.ReadInt16().Equals(0));
                        level[k].Y0 = ROMbuf.ReadByte();
                        level[k].P0 = ROMbuf.ReadByte();
                        level[k].Y1 = ROMbuf.ReadByte();
                        level[k].P1 = ROMbuf.ReadByte();
                        level[k].Y2 = ROMbuf.ReadByte();
                        level[k].P2 = ROMbuf.ReadByte();
                        level[k].Y3 = ROMbuf.ReadByte();
                        level[k].P3 = ROMbuf.ReadByte();
                        level[k].unused0 = Int32Swap(ROMbuf.ReadInt32());
                        level[k].unused1 = Int32Swap(ROMbuf.ReadInt32());
                        if (ROMversion != EccoVersions._E2A)
                            level[k].Levelname = new string(ROMbuf.ReadChars(16));
                        else
                            level[k].Levelname = "";
                    }
                }
            }
            else
                richTextBox1.Text += "No new file opened.\n";
            TotalLevels = 0;
        }

        public void loadEcco2RamdumpOrSavestateToolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.Text = richTextBox1.Text + "Select SaveState/Ramdump file...\n";
            OpenEccoState = new OpenFileDialog();
            if (OpenEccoState.ShowDialog(this) == System.Windows.Forms.DialogResult.OK)
            {
                Last_File_Opened = CurrentOppened.RAMdump;
                RAMver = new VersionPopup();
                RAMver.ShowDialog();
                EccoSS = new FileInfo(OpenEccoState.FileName);
                filesize = (int)EccoSS.Length;
                EccoSSstream = EccoSS.Open(FileMode.Open, FileAccess.Read);



                Level_variablesloc = RamVariables[(int)RAMversion];
                //Detect file type by size ( :/ )
                if ((filesize == 140408) && (true)) // Savestate
                {
                    Last_File_Opened = CurrentOppened.SaveState;
                    Level_variablesloc += 0x2478;
                    richTextBox1.Text += "This file was detected as a Savestate...\n";
                }



                richTextBox1.Text += "Opened " + '"' + OpenEccoState.FileName + '"' + "\n";

               


                buf = new BinaryReader(EccoSSstream);
                //Bufferseek into the start of the variables
                buf.BaseStream.Seek(RamVariables[(int)RAMversion], SeekOrigin.Begin);
                
                objectmaploc = buf.ReadInt32();
                objectlistloc = buf.ReadInt32();

                //Goto the next group of important vars:
                buf.BaseStream.Seek(0x16, SeekOrigin.Current);
                FGmaploc = buf.ReadInt32();
                //Unused width*height:
                buf.ReadInt16();
                FGwidth = Int16Swap(buf.ReadInt16());
                FGheight = Int16Swap(buf.ReadInt16());

                buf.BaseStream.Seek(0x20, SeekOrigin.Current);
                BGmaploc = buf.ReadInt32();
                //Unused width*height:
                buf.ReadInt16();
                BGwidth = Int16Swap(buf.ReadInt16());
                BGheight = Int16Swap(buf.ReadInt16());


                //Write read result into the bottom textbox:
                richTextBox1.Text += "Object map: 0x" + Int32Swap(objectmaploc).ToString("X").PadLeft(8, '0') + "; object lists: 0x" + Int32Swap(objectlistloc).ToString("X").PadLeft(8, '0') +  "\n";
                richTextBox1.Text += "Foreground map: 0x" + Int32Swap(FGmaploc).ToString("X").PadLeft(8, '0') + "; width: 0x" + FGwidth.ToString("X").PadLeft(4, '0') + "; height: 0x" + FGheight.ToString("X").PadLeft(4, '0') + "\n";
                richTextBox1.Text += "Background map: 0x" + Int32Swap(BGmaploc).ToString("X").PadLeft(8, '0') + "; width: 0x" + BGwidth.ToString("X").PadLeft(4, '0') + "; height: 0x" + BGheight.ToString("X").PadLeft(4, '0') + "\n";
                richTextBox1.Text += FGwidth.ToString() + " " + FGheight.ToString() + " " + BGwidth.ToString() + " " + BGheight.ToString() + "\n";

                //Check if the savestate/dump is usable (level structure complete in ram)
                if (((Int32Swap(objectmaploc) & 0x00E00000) |
                     (Int32Swap(objectlistloc) & 0x00E00000) |
                     (Int32Swap(FGmaploc) & 0x00E00000) |
                     (Int32Swap(BGmaploc) & 0x00E00000)) != 0x00E00000)
                {
                    richTextBox1.Text += "#ERROR: This file is not usable, because it lacks RAM data!\n";
                    Level_variablesloc = RamVariables[(int)RAMversion];
                    buf.Close();
                    return;
                }
                
                foregroundmap = new short[FGheight][];
                FGmap_secondary = new Secondary_Layout[FGheight][];
                backgroundmap = new short[BGheight][];
                BGmap_secondary = new Secondary_Layout[BGheight][];
                objmap = new byte[FGheight][][];

                //copy file-stored level layout into a 2D array
                buf.BaseStream.Seek(0, SeekOrigin.Begin);
                for (i = 0; i < FGheight; i++)
                {
                    foregroundmap[i] = new short[FGwidth];
                    objmap[i] = new byte[FGwidth][];
                    for (j = 0; j < FGwidth; j++)
                        foregroundmap[i][j] = Int16Swap(buf.ReadInt16());
                }

                //fseek into bg layout
                buf.BaseStream.Seek((Int32Swap(BGmaploc) & 0x7FFF), SeekOrigin.Begin);
                for (i = 0; i < BGheight; i++)
                {
                    backgroundmap[i] = new short[BGwidth];
                    for (j = 0; j < BGwidth; j++)
                        backgroundmap[i][j] = Int16Swap(buf.ReadInt16()); 
                }   
                buf.Close();
                LoadLevelPanel();
            }
            else
                richTextBox1.Text = richTextBox1.Text + "No new file opened.\n";
        }

        private void generateATemplateLevelToolStripMenuItem_Click(object sender, EventArgs e)
        {
            richTextBox1.Text = richTextBox1.Text + "Please select the tileset which the level will use...\n";
        }



//Layers Menu-items:
        private void tilesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foregroundON = tilesToolStripMenuItem.Checked;
            backgroundON = !backgroundON;
            LevelScrollBar_H.Minimum = 0;
            LevelScrollBar_H.Value = 0;
            LevelScrollBar_V.Minimum = 0;
            LevelScrollBar_V.Value = 0;
            if (foregroundON)
            {
                backgroundToolStripMenuItem.Checked = false;
                LoadLevelPanel();
            }
        }

        private void backgroundToolStripMenuItem_Click(object sender, EventArgs e)
        {
            backgroundON = backgroundToolStripMenuItem.Checked;
            foregroundON = !foregroundON;
            collisionON = false;
            collisionToolStripMenuItem.Checked = false;
            LevelScrollBar_H.Minimum = 0;
            LevelScrollBar_H.Value = 0;
            LevelScrollBar_V.Minimum = 0;
            LevelScrollBar_V.Value = 0;
            if (backgroundON)
            {
                tilesToolStripMenuItem.Checked = false;
                LoadLevelPanel();
            }
        }

        private void collisionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            collisionON = collisionToolStripMenuItem.Checked;
            UpdateLevelPanel(LevelScrollBar_H.Value, LevelScrollBar_V.Value);
        }

        private void objectsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            objectsON = !objectsON;
            if(objectsON)
                richTextBox1.Text += "Objects displayed\n";
            else
                richTextBox1.Text += "Objects hidden\n";
        }



        private void BlocksScrollBar_Scroll(object sender, ScrollEventArgs e)
        {
            UpdateTileSetPanel(BlocksScrollBar.Value);
        }

        private void inASingleFileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveRawMAP = new SaveFileDialog();
            SaveRawMAP.Dispose();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            Point NumericLocation = new Point(12, 50);
            Point LabelLocation = new Point(58, 53);
            Size TextBoxSize = new Size(40, 20);
            Obj_Parameters = new NumericUpDown[16];
            Parameter_Description = new Label[16];
            LoadTileSet();
            LoadTileSetPanel(0);
            SelectedpictureBox.Image = tileImages[0][0x0000];
            selectedTile = 0;
            OriginalPanelSize = new Size(pnlLevel.Width, pnlLevel.Height);
            LoadLevelPanel();
            UpdateLevelPanel(0, 0);

            //This changes the current tab to the collision page, so the next controls are drawn on it
            tabControl1.SelectedTab = Objects;
            
            for (i = 0; i < 16; i++)
            {
                Obj_Parameters[i] = new NumericUpDown();
                Obj_Parameters[i].Location = NumericLocation;
                Obj_Parameters[i].Size = TextBoxSize;
                Obj_Parameters[i].Name = "ObjParam" + i.ToString();
                Obj_Parameters[i].Hexadecimal = true;
                Obj_Parameters[i].Minimum = 0;
                Obj_Parameters[i].Maximum = 0xFF;
                Obj_Parameters[i].TabIndex = 5 + i;
                Obj_Parameters[i].Parent = Objects;
                Obj_Parameters[i].BringToFront();
                //Obj_Parameters[i].CreateObjRef(System.Type);

                Parameter_Description[i] = new Label();
                Parameter_Description[i].Location = LabelLocation;
                Parameter_Description[i].Size = new Size(96, 13);
                Parameter_Description[i].Name = "label " + i.ToString();
                Parameter_Description[i].Text = "label " + i.ToString();
                Parameter_Description[i].Parent = Objects;
                Parameter_Description[i].BringToFront();
                NumericLocation.Y += 26;
                LabelLocation.Y += 26;
            }
            tabControl1.SelectedTab = Blocks;
            Parameter_Description[0].Text = "Object ID";
            Parameter_Description[1].Text = "Sequence number";
            Parameter_Description[1].Enabled = false; //lock Seq#
            Parameter_Description[2].Text = "Object flags";
            Parameter_Description[3].Text = "In-Block position";
        }

        private void Clear_Click(object sender, EventArgs e)
        {
            richTextBox1.Text = "Log\n";
        }

        private void richTextBox1_TextChanged(object sender, EventArgs e)
        {
            richTextBox1.Select(richTextBox1.Text.Length, 0);
            richTextBox1.ScrollToCaret();
        }

        private void levelPropertiesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            #region Error popups if options are invalid
            if (EccoROMstream == null)
            {
                ErrorWinn = new ErrorPopup("No ROM loaded...");
                ErrorWinn.Enabled = true;
                ErrorWinn.ShowDialog();
                return;
            }
            if (comboBox1.SelectedItem == null)
            {
                ErrorWinn = new ErrorPopup("No level selected...");
                ErrorWinn.Enabled = true;
                ErrorWinn.ShowDialog();
                return;
            }
            #endregion
            k = comboBox1.Items.IndexOf(comboBox1.SelectedItem);
            LevelOptions = new LevelProperties(pallete, palleteRAW, (int)TotalPalletes[ThisLevelGroup],
                FGwidth, FGheight, BGwidth, BGheight, A[ThisLevelGroup][ThisLevelIndex].ROM_Xstart,
                A[ThisLevelGroup][ThisLevelIndex].ROM_Ystart, A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable,
                A[ThisLevelGroup][ThisLevelIndex].ROM_Yviewable, level[k]);
            
            LevelOptions.Enabled = true;
            LevelOptions.ShowDialog();
        }

        private void e2EDConfigurationToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ConfigurationWindow = new E2ED_Conf(AdvancedEditor);
            ConfigurationWindow.Enabled = true;
            ConfigurationWindow.ShowDialog();
        }


        /// <summary>
        /// Maps bitmaps into offsets
        /// Adapted all code from Vile1101
        /// </summary>    
        #region resourses.add
        private void LoadTileSet()
        {
            // gets all the tiles of the current tileset and stores them in a collection.
            // I would prefer a more automatic way to load tiles, but this will do for now. I'm not that well versed in resource management.
            // For one, it should never be neccessary to write lots of redundant code like this, but this isn't what I wanted to show you 
            // so don't worry about it just yet.

            tileImages = new Dictionary<short, Bitmap>[4];
            for (i = 0; i < 4; i++)
            {
                tileImages[i] = new Dictionary<short, Bitmap>();
                tileImages[i].Add(0x0C01, PresentVortexTiles._0C01);
                tileImages[i].Add(0x0C02, PresentVortexTiles._0C02);
                tileImages[i].Add(0x0C03, PresentVortexTiles._0C03);
                tileImages[i].Add(0x0000, PresentVortexTiles._0000);
            }

        }
        private void LoadTileSet2(int PalIX)
        {
            if(tileImages == null)
                tileImages = new Dictionary<short, Bitmap>[4];
            //if(tileImages[PalIX] == null)
                tileImages[PalIX] = new Dictionary<short, Bitmap>();
            
            for (i = 0; i < num_of_128blocks; i++)
            {
                if(ptrs_128x128[i] == -1)
                    tileImages[PalIX].Add((short)(i | 0x0C00), PresentVortexTiles._null);
                else
                    tileImages[PalIX].Add((short)(i | 0x0C00), Blockimages[PalIX][i]);
            }
//            tileImages[PalIX].Add(0x0000, PresentVortexTiles._0000);
        }
        private void LoadSonarPics()
        {
            Color transparent = new Color();
            transparent = Color.FromArgb(0xFF, 0x00, 0xFF);
            SonarImages = new Dictionary<int, Bitmap>();
            //SonarImages.Add(0x00000007, SonarIcons.Hazard);     //moving rock/shell or any other object
            SonarImages.Add(0x00000008, SonarIcons.Jellyfish);
            SonarImages.Add(0x00000009, SonarIcons.Fishes);
            SonarImages.Add(0x0000000A, SonarIcons.Fishes);
            SonarImages.Add(0x0000000B, SonarIcons.Fishes);
            SonarImages.Add(0x0000000F, SonarIcons.Air_Bubble);
            SonarImages.Add(0x00000012, SonarIcons.Hazard);  //Crab
            SonarImages.Add(0x00000013, SonarIcons.Glyph);
            SonarImages.Add(0x00000014, SonarIcons.Glyph);
            SonarImages.Add(0x00000017, SonarIcons.Hazard);  //Puffer following ecco I think
            SonarImages.Add(0x00000018, SonarIcons.Shark_R);
            SonarImages.Add(0x00000019, SonarIcons.Dolphin_R);
            SonarImages.Add(0x0000001A, SonarIcons.Shelled_one);
            SonarImages.Add(0x00000022, SonarIcons.Hazard);
            SonarImages.Add(0x00000023, SonarIcons.Hazard);
            SonarImages.Add(0x00000026, SonarIcons.BarrierBoulder); //Breakable rocks
            SonarImages.Add(0x00000029, SonarIcons.Air_Bubble);
            SonarImages.Add(0x0000002E, SonarIcons.Vortex);
            SonarImages.Add(0x00000034, SonarIcons.SpikedShell);
            SonarImages.Add(0x00000036, SonarIcons.Movable_block);
            SonarImages.Add(0x00000039, SonarIcons.Dolphin_R);
            SonarImages.Add(0x0000003A, SonarIcons.Dolphin_R);
            SonarImages.Add(0x0000003B, SonarIcons.Warp);
            //SonarImages.Add(0x0000003F, SonarIcons.Dolphin_R);  //Dolphin sonaring a drone
            SonarImages.Add(0x00000040, SonarIcons.Glyph);
            SonarImages.Add(0x00000047, SonarIcons.Exit_U);
            SonarImages.Add(0x00000048, SonarIcons.Exit_B);
            SonarImages.Add(0x0000004C, SonarIcons.Glyph);
            //SonarImages.Add(0x0000004D, SonarIcons.Glyph);  //Glyph group, more accurately
            SonarImages.Add(0x0000004E, SonarIcons.Glyph);
            SonarImages.Add(0x0000004F, SonarIcons.Glyph_T);
            SonarImages.Add(0x00000055, SonarIcons.Turtle);
            SonarImages.Add(0x00000056, SonarIcons.AsteriteGlobe);
            SonarImages.Add(0x00000057, SonarIcons.Warp);
            SonarImages.Add(0x00000058, SonarIcons.Metasphere);
            SonarImages.Add(0x0000005B, SonarIcons.Dolphin_R);
            SonarImages.Add(0x0000005C, SonarIcons.C_Glyph);
            SonarImages.Add(0x0000005E, SonarIcons.Worm);
            SonarImages.Add(0x00000060, SonarIcons.Jellyfish);
            SonarImages.Add(0x00000061, SonarIcons.Worm);
            SonarImages.Add(0x00000064, SonarIcons.Dolphin_R);
            SonarImages.Add(0x00000065, SonarIcons.Worm);
            SonarImages.Add(0x00000066, SonarIcons.Worm);
            SonarImages.Add(0x00000067, SonarIcons.Worm);
            SonarImages.Add(0x00000068, SonarIcons.Worm);
            SonarImages.Add(0x00000069, SonarIcons.Worm);
            SonarImages.Add(0x0000006A, SonarIcons.Dolphin_R);
            SonarImages.Add(0x0000006D, SonarIcons.Fish);
            SonarImages.Add(0x00000071, SonarIcons.BarrierBoulder);  //Song shatter blocks
            SonarImages.Add(0x00000072, SonarIcons.Movable_block);      // unused rope object
            SonarImages.Add(0x00000074, SonarIcons.Hazard);  //Instable Stalacticte
            SonarImages.Add(0x00000076, SonarIcons.Worm);
            SonarImages.Add(0x00000079, SonarIcons.Dolphin_R);
            SonarImages.Add(0x0000007A, SonarIcons.Giant_Medusa);
            SonarImages.Add(0x0000007B, SonarIcons.Dolphin_R);
            SonarImages.Add(0x00000082, SonarIcons.Worm);   //GlobeHolder
            SonarImages.Add(0x00000084, SonarIcons.Trellia);    //Timetravel WOO
            SonarImages.Add(0x00000089, SonarIcons.Worm);
            SonarImages.Add(0x0000008A, SonarIcons.Movable_block);
            SonarImages.Add(0x0000008C, SonarIcons.Fish);
            SonarImages.Add(0x00000091, SonarIcons.Exit_3D);
            SonarImages.Add(0x00000092, SonarIcons.Exit_3D);
            SonarImages.Add(0x00000097, SonarIcons.Glyph);
            SonarImages.Add(0x0000009A, SonarIcons.Vortex);
            SonarImages.Add(0x0000009B, SonarIcons.Worm);    //Good future worm (used in asterite's cave)
            //SonarImages.Add(0x0000009D, SonarIcons.---);  //animated BG birds (prop)
            SonarImages.Add(0x0000009E, SonarIcons.Exit_U);
            SonarImages.Add(0x0000009F, SonarIcons.Exit_U);
            SonarImages.Add(0x000000A5, SonarIcons.Exit_L);

            SonarImages.Add(0x000000A4, SonarIcons.Worm);    //Conch worm
            SonarImages.Add(0x000000AC, SonarIcons.Dolphin_L);
            SonarImages.Add(0x000000AE, SonarIcons.Air_Propeller);
            SonarImages.Add(0x000000AF, SonarIcons.Larva);
            SonarImages.Add(0x000000B1, SonarIcons.Glyph_B); //not sure but... ummm
            SonarImages.Add(0x000000C4, SonarIcons.Glyph_B);
            SonarImages.Add(0x000000C5, SonarIcons.Glyph);
            SonarImages.Add(0x000000C8, SonarIcons.Hazard);
            SonarImages.Add(0x000000C9, SonarIcons.Hazard);
            SonarImages.Add(0x000000CA, SonarIcons.Trellia); //future dolphin facing left
                SonarImages[0xCA].RotateFlip(RotateFlipType.RotateNoneFlipX);
            SonarImages.Add(0x000000CB, SonarIcons.Trellia); //future dolphin facing right
            SonarImages.Add(0x000000CD, SonarIcons.Vortex);
            SonarImages.Add(0x000000D0, SonarIcons.Pulsar);
            foreach (Bitmap a in SonarImages.Values)
            {
                a.MakeTransparent(transparent);
            }

        }
        #endregion


        /// <summary>
        /// Creates a bitmap containing 64x64 representations of all the tiles in the tile set.
        /// Written by Vile1101
        /// </summary>
        private void LoadTileSetPanel(int PalIX)
        {
            int padding = 1;
            int tileSize = 64;

            tileLocations = new Dictionary<Rectangle, short>();

            int tilesPerRow = pnlTileSet.Width / (tileSize + padding);
            tileSetImage = new Bitmap(pnlTileSet.Width, ((((tileImages[PalIX].Count + 1) >> 1) << 1) / tilesPerRow) * (tileSize + padding));
            tileSetViewableImage = new Bitmap(pnlTileSet.Width, pnlTileSet.Height);

            Rectangle src = new Rectangle(0,0,128,128);
            Rectangle dest = new Rectangle(padding, padding, tileSize, tileSize);
            foreach (KeyValuePair<short, Bitmap> tile in tileImages[PalIX])
            {
                CopyImageRegion(tile.Value, tileSetImage, src, dest);
                tileLocations.Add(dest, tile.Key);

                dest.X += (tileSize + padding);
                if (dest.Right >= pnlTileSet.Width)
                {
                    dest.X = padding;
                    dest.Y += (tileSize + padding);
                }
            }

            if (tileSetImage.Height > pnlTileSet.Height)
                BlocksScrollBar.Maximum = tileSetImage.Height - pnlTileSet.Height + tileSize + padding;
            else
                BlocksScrollBar.Maximum = 0;
            BlocksScrollBar.Value = 0;
            UpdateTileSetPanel(0);
        }

        /// <summary>
        /// Creates a bitmap of the current level. 
        /// Modified code provided by Vile1101
        /// </summary>
        private void LoadLevelPanel()
        {
            int y;
            int x;
            int Current_Pallete_in_use;
            Rectangle src = new Rectangle(0, 0, 128, 128);
            Rectangle dest = new Rectangle(0, 0, 128, 128);
            if (levelImage != null)
                levelImage.Dispose();
            if (levelViewableImage != null)
                levelViewableImage.Dispose();

            levelViewableImage = new Bitmap(pnlLevel.Width, pnlLevel.Height);
            levelImage = new Bitmap(FGwidth * 128, FGheight * 128);
            LevelScrollBar_H.Minimum = 0;
            LevelScrollBar_H.Maximum = (FGwidth + 1) * 128 - pnlLevel.Size.Width;
            LevelScrollBar_H.Minimum = 0;
            LevelScrollBar_V.Maximum = (FGheight + 1) * 128 - pnlLevel.Size.Height;


            if ((buf != null) || (ROMbuf != null))
            {
                pnlLevel.Size = OriginalPanelSize;
                pnlLevel.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Bottom | AnchorStyles.Right;
                pnlLevel.BackColor = Color.FromArgb(0, 0, 0);
                if (backgroundON)
                {
                    if ((BGheight << 7) < pnlLevel.Size.Height)
                    {
                        PanelSize = new Size(pnlLevel.Size.Width, (BGheight << 7) + 3);
                        pnlLevel.Size = PanelSize;
                        pnlLevel.Anchor = AnchorStyles.Top | AnchorStyles.Left;
                    }
                    if ((BGwidth << 7) < pnlLevel.Size.Width)
                    {
                        PanelSize = new Size((BGwidth << 7) + 3, pnlLevel.Size.Height);
                        pnlLevel.Size = PanelSize;
                        pnlLevel.Anchor = AnchorStyles.Top | AnchorStyles.Left;
                    }
                }

                if (foregroundON)
                {
                    if ((FGheight << 7) < pnlLevel.Size.Height)
                    {
                        PanelSize = new Size(pnlLevel.Size.Width, (FGheight << 7) + 3);
                        pnlLevel.Size = PanelSize;
                        pnlLevel.Anchor = AnchorStyles.Top | AnchorStyles.Left;
                    }
                    if ((FGwidth << 7) < pnlLevel.Size.Width)
                    {
                        PanelSize = new Size((FGwidth << 7) + 3, pnlLevel.Size.Height);
                        pnlLevel.Size = PanelSize;
                        pnlLevel.Anchor = AnchorStyles.Top | AnchorStyles.Left;
                    }

                    if (levelImage != null)
                        levelImage.Dispose();
                    levelImage = new Bitmap(FGwidth * 128, FGheight * 128);
                    LevelScrollBar_H.Minimum = 0;
                    LevelScrollBar_H.Maximum = (FGwidth + 1) * 128 - pnlLevel.Size.Width;
                    LevelScrollBar_H.Minimum = 0;
                    LevelScrollBar_V.Maximum = (FGheight + 1) * 128 - pnlLevel.Size.Height;
                    Current_Pallete_in_use = 0;
                    for (y = 0; y < FGheight; y++)
                    {
                        if ((y > level[ThisLevelOffset].Y1) && (level[ThisLevelOffset].Y1 != 0))
                            Current_Pallete_in_use = 1;
                        if ((y > level[ThisLevelOffset].Y2) && (level[ThisLevelOffset].Y2 != 0))
                            Current_Pallete_in_use = 2;
                        if ((y > level[ThisLevelOffset].Y3) && (level[ThisLevelOffset].Y3 != 0))
                            Current_Pallete_in_use = 3;
                        for (x = 0; x < FGwidth; x++)
                        {
                            dest.X = x * 128;
                            dest.Y = y * 128;
                            ClearImageRegion(levelImage, dest);
                            if ((foregroundmap[y] != null))
                            {
                                if ((foregroundmap[y][x] & 0x00FF) > num_of_128blocks)
                                {
                                    richTextBox1.Text += "x: 0x" + x.ToString("X").PadLeft(4, '0') + " y: 0x" + y.ToString("X").PadLeft(4, '0') + "is out of block range\n";
                                    ClearImageRegion(levelImage, dest);
                                    continue;
                                }

                                //Special case of empty blocks:
                                if ((foregroundmap[y][x] & 0x0400) == 0)
                                    goto PaintsecondaryblocksFG;

                                //Adjust flip if flags are set:
                                if ((foregroundmap[y][x] & 0x0100) == 0x0100)
                                    tileImages[Current_Pallete_in_use][((short)((foregroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipY);
                                if ((foregroundmap[y][x] & 0x0200) == 0x0200)
                                    tileImages[Current_Pallete_in_use][((short)((foregroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipX);
                                CopyImageRegion(tileImages[Current_Pallete_in_use][((short)((short)((short)foregroundmap[y][x] & (short)0x00FF) | (short)0x0C00))], levelImage, src, dest);

                                //Revert filpping to none:
                                if ((foregroundmap[y][x] & 0x0100) == 0x0100)
                                    tileImages[Current_Pallete_in_use][((short)((foregroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipY);
                                if ((foregroundmap[y][x] & 0x0200) == 0x0200)
                                    tileImages[Current_Pallete_in_use][((short)((foregroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipX);


                            PaintsecondaryblocksFG:
                                if (FGmap_secondary[y] != null)
                                {
                                    for (i = 0; i < FGmap_secondary[y][x].number_of_elements; i++)
                                    {
                                        dest.X += ((FGmap_secondary[y][x].overlay_map[i] >> 8) & 0x0F) << 3;
                                        dest.Y += ((FGmap_secondary[y][x].overlay_map[i] >> 12) & 0x0F) << 3;
                                        src.Width = SpecialBlockImages[0][FGmap_secondary[y][x].overlay_map[i] & 0x00FF].Width;
                                        src.Height = SpecialBlockImages[0][FGmap_secondary[y][x].overlay_map[i] & 0x00FF].Height;
                                        dest.Width = SpecialBlockImages[0][FGmap_secondary[y][x].overlay_map[i] & 0x00FF].Width;
                                        dest.Height = SpecialBlockImages[0][FGmap_secondary[y][x].overlay_map[i] & 0x00FF].Height;

                                        ClearImageRegion(levelImage, dest);
                                        CopyImageRegion(SpecialBlockImages[Current_Pallete_in_use][FGmap_secondary[y][x].overlay_map[i] & 0x00FF], levelImage, src, dest);

                                        src.Width = 128;
                                        src.Height = 128;
                                        dest.Width = 128;
                                        dest.Height = 128;
                                        dest.X = x * 128;
                                        dest.Y = y * 128;
                                    }
                                }
                            }
                        }
                    }
                }
                if (backgroundON)
                {
                    if (levelImage != null)
                        levelImage.Dispose();
                    levelImage = new Bitmap(BGwidth * 128, BGheight * 128);
                    LevelScrollBar_H.Maximum = (BGwidth + 1) * 128 - pnlLevel.Size.Width;
                    LevelScrollBar_V.Maximum = (BGheight + 1) * 128 - pnlLevel.Size.Height;
                    Current_Pallete_in_use = 0;
                    for (y = 0; y < BGheight; y++)
                    {
                        if ((y > level[ThisLevelOffset].Y1) && (level[ThisLevelOffset].Y1 != 0))
                            Current_Pallete_in_use = 1;
                        if ((y > level[ThisLevelOffset].Y2) && (level[ThisLevelOffset].Y2 != 0))
                            Current_Pallete_in_use = 2;
                        if ((y > level[ThisLevelOffset].Y3) && (level[ThisLevelOffset].Y3 != 0))
                            Current_Pallete_in_use = 3;

                        for (x = 0; x < BGwidth; x++)
                        {
                            dest.X = x * 128;
                            dest.Y = y * 128;
                            ClearImageRegion(levelImage, dest);
                            if (backgroundmap != null)
                            {
                                if ((backgroundmap[y][x] & 0x00FF) > num_of_128blocks)
                                {
                                    richTextBox1.Text += "x: 0x" + x.ToString("X").PadLeft(4, '0') + " y: 0x" + y.ToString("X").PadLeft(4, '0') + " is out of block range\n";
                                    CopyImageRegion(tileImages[Current_Pallete_in_use][0000], levelImage, src, dest);
                                    continue;
                                }
                                //Special case of empty blocks:
                                if ((backgroundmap[y][x] & 0x0400) == 0)
                                    goto PaintsecondaryblocksBG;

                                //Adjust flip if flags are set:
                                if ((backgroundmap[y][x] & 0x0100) == 0x0100)
                                    tileImages[Current_Pallete_in_use][((short)((backgroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipY);
                                if ((backgroundmap[y][x] & 0x0200) == 0x0200)
                                    tileImages[Current_Pallete_in_use][((short)((backgroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipX);
                                CopyImageRegion(tileImages[Current_Pallete_in_use][((short)((short)((short)backgroundmap[y][x] & (short)0x00FF) | (short)0x0C00))], levelImage, src, dest);
                                //Revert filpping to none:
                                if ((backgroundmap[y][x] & 0x0100) == 0x0100)
                                    tileImages[Current_Pallete_in_use][((short)((backgroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipY);
                                if ((backgroundmap[y][x] & 0x0200) == 0x0200)
                                    tileImages[Current_Pallete_in_use][((short)((backgroundmap[y][x] & 0x00FF) | 0x0C00))].RotateFlip(RotateFlipType.RotateNoneFlipX);

                            PaintsecondaryblocksBG:
                                if (BGmap_secondary[y] != null)
                                {
                                    for (i = 0; i < BGmap_secondary[y][x].number_of_elements; i++)
                                    {
                                        dest.X += ((BGmap_secondary[y][x].overlay_map[i] >> 8) & 0x0F) << 3;
                                        dest.Y += ((BGmap_secondary[y][x].overlay_map[i] >> 12) & 0x0F) << 3;
                                        src.Width = SpecialBlockImages[0][BGmap_secondary[y][x].overlay_map[i] & 0x00FF].Width;
                                        src.Height = SpecialBlockImages[0][BGmap_secondary[y][x].overlay_map[i] & 0x00FF].Height;
                                        dest.Width = SpecialBlockImages[0][BGmap_secondary[y][x].overlay_map[i] & 0x00FF].Width;
                                        dest.Height = SpecialBlockImages[0][BGmap_secondary[y][x].overlay_map[i] & 0x00FF].Height;

                                        ClearImageRegion(levelImage, dest);
                                        CopyImageRegion(SpecialBlockImages[Current_Pallete_in_use][BGmap_secondary[y][x].overlay_map[i] & 0x00FF], levelImage, src, dest);

                                        src.Width = 128;
                                        src.Height = 128;
                                        dest.Width = 128;
                                        dest.Height = 128;
                                        dest.X = x * 128;
                                        dest.Y = y * 128;
                                    }
                                }
                            }
                        }
                    }
                }
                UpdateLevelPanel(0, 0);
            }
        }


        /// <summary>
        /// Code for displaying the visible portion,
        /// loading bitmaps to the left panel,
        /// and painting the selected block into the level bitmap
        /// </summary>
        #region Miscelaneous code written by Vile1101
        /// <summary>
        /// Sets up the viewable portion of the tile set. 
        /// Written by Vile1101
        /// </summary>
        /// <param name="scrollStart"></param>
        private void UpdateTileSetPanel(int scrollStart)
        {
            Rectangle src = new Rectangle(0, scrollStart, pnlTileSet.Width, pnlTileSet.Height);

            Graphics g = Graphics.FromImage(tileSetViewableImage);
            g.Clear(Color.Black);
            CopyImageRegion(tileSetImage,tileSetViewableImage, src, new Rectangle(0,0,pnlTileSet.Width,pnlTileSet.Height));
            pnlTileSet.Refresh();
            g.Dispose();
        }


        /// <summary>
        /// Sets up the viewable portion of the level panel.
        /// </summary>
        /// <param name="scrollX"></param>
        /// <param name="scrollY"></param>
        private void UpdateLevelPanel(int scrollX, int scrollY)
        {
            Rectangle src = new Rectangle(scrollX, scrollY, pnlLevel.Width, pnlLevel.Height);
            
            levelViewableImage.Dispose();
            levelViewableImage = new Bitmap(pnlLevel.Width, pnlLevel.Height);
            //Graphics g = Graphics.FromImage(levelViewableImage);
            CopyImageRegion(levelImage, levelViewableImage, src, new Rectangle(0, 0, pnlLevel.Width, pnlLevel.Height));
            Graphics g = Graphics.FromHwnd(pnlLevel.Handle);
            g.Clear(Color.FromArgb(0, 0, 0));
            if (collisionON)
                Draw_Colison_Shapes();
            g.DrawImage(levelViewableImage, 0, 0);
            g.Dispose();
            //DrawLevelPanel();
        }

        // This helps with smoothly scrolling the level. Without using this, you will get an occasional flicker.
        private void DrawLevelPanel()
        {           
            if (levelViewableImage != null)
            {
                Graphics g = Graphics.FromHwnd(pnlLevel.Handle);
                g.DrawImage(levelViewableImage, 0, 0);
                g.Dispose();
            }
        }

        private void CopyImageRegion(Bitmap src, Bitmap dest, Rectangle recSrc, Rectangle recDest)
        {
            Graphics g = Graphics.FromImage(dest);
            g.DrawImage(src, recDest, recSrc, GraphicsUnit.Pixel);
            g.Dispose();
        }
        private void ClearImageRegion(Bitmap dest, Rectangle recDest)
        {
            Graphics g = Graphics.FromImage(dest);
            g.Clip = new Region(recDest);
            g.Clear(Color.FromArgb(0, 0, 0));
            g.Dispose();
        }

        private void pnlTileSet_Paint(object sender, PaintEventArgs e)
        {
            if (tileSetViewableImage != null)
            {
                e.Graphics.DrawImage(tileSetViewableImage, new Point(0, 0));
                e.Dispose();
            }
        }

        private void pnlTileSet_MouseUp(object sender, MouseEventArgs e)
        {
            if (PaintMode.Checked)
            {
                Point pt = e.Location;
                pt.Y += BlocksScrollBar.Value;
                FlipHCheckBox.Checked = false;
                FlipVCheckBox.Checked = false;
                // figure out what tile was clicked on. 
                foreach (KeyValuePair<Rectangle, short> kvp in tileLocations)
                {
                    if (kvp.Key.Contains(pt))
                    {
                        selectedTile = kvp.Value;
                        SelectedpictureBox.Image = tileImages[(int)PalSelection.Value][selectedTile];
                        return;
                    }
                }
                selectedTile = 0;
            }
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            UpdateLevelPanel(LevelScrollBar_H.Value, LevelScrollBar_V.Value);
        }

        private void LevelScrollBar_V_Scroll_1(object sender, ScrollEventArgs e)
        {
            UpdateLevelPanel(LevelScrollBar_H.Value, LevelScrollBar_V.Value);
        }

        private void LevelScrollBar_H_Scroll_1(object sender, ScrollEventArgs e)
        {
            UpdateLevelPanel(LevelScrollBar_H.Value, LevelScrollBar_V.Value);
        }

        private void pnlLevel_MouseUp(object sender, MouseEventArgs e)
        {
            ClickedLocation = new Point(e.X + LevelScrollBar_H.Value, e.Y + LevelScrollBar_V.Value);
            Rectangle cell = new Rectangle((ClickedLocation.X / 128) * 128, (ClickedLocation.Y / 128) * 128, 128, 128);
            Rectangle Src = new Rectangle(0, 0, 128, 128);
            Rectangle Dst = new Rectangle(0, 0, 128, 128);
            string Tooltip_Txt = new string('s', 2);
            if (SelectedImage != null)
                SelectedImage.Dispose();
            SelectedImage = new Bitmap(128, 128);
            #region Blocks tab page
            if (tabControl1.SelectedTab == Blocks)
            {
                if (PaintMode.Checked)
                {
                    //CopyImageRegion(tileImages[0][0x0000], levelImage, new Rectangle(0, 0, 128, 128), cell);
                    CopyImageRegion(tileImages[(int)PalSelection.Value][selectedTile], levelImage, new Rectangle(0, 0, 128, 128), cell);
                    if (foregroundON && foregroundmap != null && foregroundmap[0] != null)
                        foregroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] = selectedTile;
                    if (backgroundON && backgroundmap != null && backgroundmap[0] != null)
                        backgroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] = selectedTile;
                    UpdateLevelPanel(LevelScrollBar_H.Value, LevelScrollBar_V.Value);
                }
                if (SelectMode.Checked)
                {
                    //temp1: pallete selection
                    temp1 = 0;
                    if (level == null)
                    {
                        if (SelectedImage != null)
                            SelectedImage.Dispose();
                        return;
                    }
                    if (((ClickedLocation.Y >> 7) > level[ThisLevelOffset].Y1) && (level[ThisLevelOffset].Y1 != 0))
                        temp1 = 1;
                    if (((ClickedLocation.Y >> 7) > level[ThisLevelOffset].Y2) && (level[ThisLevelOffset].Y2 != 0))
                        temp1 = 2;
                    if (((ClickedLocation.Y >> 7) > level[ThisLevelOffset].Y3) && (level[ThisLevelOffset].Y3 != 0))
                        temp1 = 3;
                    PalSelection.Value = temp1;
                    FlipHCheckBox.Checked = false;
                    FlipVCheckBox.Checked = false;
                    if (foregroundON && (foregroundmap != null))
                    {
                        //temp0: block index
                        selectedTile = (short)(foregroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] & 0x04FF);
                        if (selectedTile >= 0x400)
                            selectedTile = (short)(selectedTile | 0x800);
                        else
                            selectedTile = 0;
                        CopyImageRegion(tileImages[temp1][selectedTile], SelectedImage, Src, Dst);
                        if ((foregroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] & 0x0100) == 0x0100)
                        {
                            SelectedImage.RotateFlip(RotateFlipType.RotateNoneFlipY);
                            FlipVCheckBox.Checked = true;
                        }
                        if ((foregroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] & 0x0200) == 0x0200)
                        {
                            SelectedImage.RotateFlip(RotateFlipType.RotateNoneFlipX);
                            FlipHCheckBox.Checked = true;
                        }
                    }
                    if (backgroundON && (backgroundmap != null))
                    {
                        selectedTile = (short)(backgroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] & 0x04FF);
                        if (selectedTile >= 0x400)
                            selectedTile = (short)(selectedTile | 0x800);
                        else
                            selectedTile = 0;
                        CopyImageRegion(tileImages[temp1][selectedTile], SelectedImage, Src, Dst);
                        if ((backgroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] & 0x0100) == 0x0100)
                        {
                            SelectedImage.RotateFlip(RotateFlipType.RotateNoneFlipY);
                            FlipVCheckBox.Checked = true;
                        }
                        if ((backgroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] & 0x0200) == 0x0200)
                        {
                            SelectedImage.RotateFlip(RotateFlipType.RotateNoneFlipX);
                            FlipHCheckBox.Checked = true;
                        }
                    }
                    SelectedpictureBox.Image = SelectedImage;
                }
                if (QueryMode.Checked == true)
                {
                    toolTip1.Active = false;
                    Tooltip_Txt = "X: " + (ClickedLocation.X >> 7).ToString() + " Y: " + (ClickedLocation.Y >> 7).ToString();
                    Tooltip_Txt += "\nBlock: ";
                    if (foregroundON)
                    {
                        if (foregroundmap[0] != null)
                            Tooltip_Txt += "0x" + foregroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7].ToString("X").PadLeft(4, '0');
                        else
                            Tooltip_Txt += null;

                        if (A[ThisLevelGroup][ThisLevelIndex].ROM_OBJmap != 0)
                            if (objmap.Length > (ClickedLocation.Y >> 7))
                                if (objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] != null)
                                {
                                    temp0 = objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][0];
                                    temp2 = 1;
                                    Tooltip_Txt += "\n# of objects: " + temp0.ToString() + "\n";
                                    while (temp0 > 0)
                                    {
                                        //
                                        for (i = 0; i < object_sizes[objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][temp2]]; i++)
                                        {
                                            Tooltip_Txt += "0x";
                                            Tooltip_Txt += objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][temp2 + i].ToString("X").PadLeft(2, '0');
                                            Tooltip_Txt += " ";
                                        }
                                        Tooltip_Txt += "\n";
                                        temp2 += object_sizes[objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][temp2]];
                                        temp0--;
                                    }
                                }
                    }
                    if (backgroundON)
                        if (backgroundmap[0] != null)
                            Tooltip_Txt += "0x" + backgroundmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7].ToString("X").PadLeft(4, '0');
                        else
                            Tooltip_Txt += null;

                    Tooltip_Txt += "\n";
                    toolTip1.SetToolTip(pnlLevel, Tooltip_Txt);
                    toolTip1.Active = true;
                }
            }
            #endregion
            #region S.Blocks tab page
            if (tabControl1.SelectedTab == SBlocks)
            {

            }
            #endregion
            #region Objects tab page
            if (tabControl1.SelectedTab == Objects)
            {
                ObjCounter.Value = 0;
                if (ChgObj.Checked)
                {
                    if (objmap == null)
                    {
                        ObjCounter.Value = 0;
                        ObjCounter.Maximum = 0;
                        ObjCounter.Enabled = false;
                        for (i = 0; i < 16; i++)
                        {
                            Obj_Parameters[i].Visible = false;
                            Parameter_Description[i].Visible = false;
                        }
                        return;
                    }
                    if (objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] == null)
                    {
                        ObjCounter.Value = 0;
                        ObjCounter.Maximum = 0;
                        ObjCounter.Enabled = false;
                        for (i = 0; i < 16; i++)
                        {
                            Obj_Parameters[i].Visible = false;
                            Parameter_Description[i].Visible = false;
                        }
                        return;
                    }
                    else
                    {
                        ObjCounter.Enabled = true;
                        ObjCounter.Maximum = objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][0] - 1;
                        for (i = 0; i < 16; i++)
                        {
                            if (i < object_sizes[objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][1]])
                            {
                                Obj_Parameters[i].Value = objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][i + 1];
                                Obj_Parameters[i].Visible = true;
                                Parameter_Description[i].Visible = true;
                            }
                            else
                            {
                                Obj_Parameters[i].Visible = false;
                                Parameter_Description[i].Visible = false;
                            }
                        }
                    }

                }
            }
            #endregion
        }
        
        #endregion


        private void exportLevelToAnImageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            LevelPIC = new SaveFileDialog();
            LevelPIC.Filter = "Portable Network Graphics|*.png";
            if (LevelPIC.ShowDialog(this) == DialogResult.OK)
                levelImage.Save(LevelPIC.FileName, ImageFormat.Png);
            LevelPIC.Dispose();
        }

        private void openSelectedLevelToolStripMenuItem_Click(object sender, EventArgs e)
        {
            #region Error popups if options are invalid
            if (EccoROMstream == null)
            {
                ErrorWinn = new ErrorPopup("No ROM loaded...");
                ErrorWinn.Enabled = true;
                ErrorWinn.ShowDialog();
                return;
            }
            if (comboBox1.SelectedItem == null)
            {
                ErrorWinn = new ErrorPopup("No level selected...");
                ErrorWinn.Enabled = true;
                ErrorWinn.ShowDialog();
                return;
            }
            #endregion
            ThisLevelIndex = comboBox1.Items.IndexOf(comboBox1.SelectedItem);
            //Get the level group and level ID from the current selection
            for (i = 0; i < number_of_LVLgroups; i++)
            {
                if (ThisLevelIndex < LevelGroup_contained_levels[i])
                {
                    ThisLevelGroup = i;
                    ThisLevelOffset = ThisLevelIndex;
                    break;
                }
                ThisLevelIndex -= LevelGroup_contained_levels[i];
            }
            ROMbuf.BaseStream.Seek((long)(LVLPrims[ThisLevelGroup].VDPregs + 12), SeekOrigin.Begin);
            temp0 = ROMbuf.ReadByte() & 0x08;
            shadow_bit = false;
            if (temp0 == 8)
                shadow_bit = true;


            #region Tile Reading / Decompression code
            secondary_decompression_buffer = new byte[4096];
            primary_decompression_buffer = new byte[65536];
            VramTileLocations = new uint[256]; 
            //^^In fact 16 is enough for every level, except globeholder, which seems to have the tiles all scattered around
            buffer_offset = 0x0FFC;
            temp0 = 0;
            i = 0;
            j = 0;
            k = 0;
            next_key_distance = 0;
            ROMbuf.BaseStream.Seek((long)(LVLPrims[ThisLevelGroup].Tiles), SeekOrigin.Begin);
            if (ROMbuf.ReadInt16() == (short)-1)
            {
                stored_size = (ROMbuf.ReadInt32());
                //progressBar1.Maximum = compressed_size + 3;
                //Reads the stream and decodes it
                while (stored_size >= 0)
                {
                    if (next_key_distance == 0)
                    {
                        key = ROMbuf.ReadByte();
                        next_key_distance = 8;
                        stored_size--;
                        //        progressBar1.Value++;
                    }

                    if ((key & 1) == 1)
                        key_bit = true;
                    else
                        key_bit = false;
                    key = (byte)(key >> 1);

                    if (key_bit)
                    {   //Direct copy
                        secondary_decompression_buffer[buffer_offset] = ROMbuf.ReadByte();
                        buffer_offset = (buffer_offset + 1) & 0x0FFF;
                        temp0++;
                        if ((temp0 == 4) && (buffer_offset == 0))
                        {
                        VramTileLocations[0] = (uint)((secondary_decompression_buffer[0x0FFC] << 16) |
                        (secondary_decompression_buffer[0x0FFD] << 24) |
                        (secondary_decompression_buffer[0x0FFE]) |
                        (secondary_decompression_buffer[0x0FFF] << 8));
                        }
                        if (temp0 >= 0x1004)
                        {
                            temp0 = 4;
                            for (i = 0; i < 4096; i++)
                            {
                                primary_decompression_buffer[i + (j << 12)] = secondary_decompression_buffer[i];
                            }
                            j++;
                        }
                        stored_size--;
                        //       progressBar1.Value++;
                    }
                    else
                    {   //Decompress
                        operator_ = Int16Swap(ROMbuf.ReadInt16());
                        repeat_counter = (operator_ & 0x0F) + 3;
                        operator_offset = ((((operator_ << 4) & 0x0F00) | ((operator_ >> 8) & 0x00FF)) + 14) & 0x0FFF;
                        while (repeat_counter > 0)
                        {
                            secondary_decompression_buffer[buffer_offset] = secondary_decompression_buffer[operator_offset];
                            buffer_offset = (buffer_offset + 1) & 0x0FFF;
                            temp0++;
                            if (temp0 >= 0x1004)
                            {
                                temp0 = 4;
                                for (i = 0; i < 4096; i++)
                                {
                                    primary_decompression_buffer[i + (j << 12)] = secondary_decompression_buffer[i];
                                }
                                j++;
                            }
                            operator_offset = (operator_offset + 1) & 0x0FFF;
                            repeat_counter--;
                        }
                        stored_size -= 2;
                        //      progressBar1.Value += 2;
                    }
                    next_key_distance--;
                }
                for (i = 0; i < 4096; i++)
                {
                    primary_decompression_buffer[i + j * 4096] = secondary_decompression_buffer[(i - 0) & 0x0FFF];
                }
            }
            else
            {
                stored_size = ((int)(Int16Swap(ROMbuf.ReadInt16()))) << 5;
                //uncompressed in this situation
                primary_decompression_buffer = ROMbuf.ReadBytes(stored_size);
            }
            #endregion

            //This is a "hack" to handle uncompressed tile sections
            if (stored_size > 0)
                VramTileLocations[0] = (uint)(stored_size >> 5) - 1;
            
            //Tile transfering to a fake Vram
            Vram = new int[16384];
            temp0 = 0;
            temp1 = 0;
            temp3 = -4;
            for (i = 1; i < 256; i++)
            {
                temp3 += ((((int)VramTileLocations[i - 1] & 0x0000FFFF) << 5) +
                         (((int)VramTileLocations[i - 1] & 0x07FF0000) << 5) + 
                         (4) & 0x0000FFFF);
                VramTileLocations[i] = (uint)((primary_decompression_buffer[temp3] << 16) |
                                       (primary_decompression_buffer[temp3 + 1] << 24) |
                                       (primary_decompression_buffer[temp3 + 2]) |
                                       (primary_decompression_buffer[temp3 + 3] << 8));
                if ((VramTileLocations[i] > 0x07FF0000) ||
                    ((VramTileLocations[i] & 0x0000FFFF) > 0x00000600) ||
                    (VramTileLocations[i] == 0) ||
                    ((i > 1) && (VramTileLocations[i] < 0x0000FFFF)))
                {
                    i--;
                    break;
                }
            }
            temp2 = i;
            for (i = 0; i <= temp2; i++)
            {
                temp1 += (int)(VramTileLocations[i] >> 16);
                for (j = 0; j < (((int)VramTileLocations[i] & 0x0000FFFF) << 3); j++)
                {
                    if ((j + temp1 * 8) >= 0x3FFF)
                    {
                        temp2--;
                        break;
                    }
                    Vram[j + temp1 * 8] = (primary_decompression_buffer[temp0 * 4 + i * 4 + j * 4] << 24) |
                    (primary_decompression_buffer[temp0 * 4 + i * 4 + j * 4 + 1] << 16) |
                    (primary_decompression_buffer[temp0 * 4 + i * 4 + j * 4 + 2] << 8) |
                    (primary_decompression_buffer[temp0 * 4 + i * 4 + j * 4 + 3]);
                }
                temp1 += j >> 3;
                temp0 += j;
            }

            Rectangle rect = new Rectangle(0, 0, 8, 8);
            System.Drawing.Imaging.BitmapData bmpData;

            #region Palletes
            //Preload the level properties panel with color from the current level group palletes

            pallete = new Color[64 * TotalPalletes[ThisLevelGroup]];
            palleteRAW = new short[64 * TotalPalletes[ThisLevelGroup]];

            //Retreaving the palletes from the ROM and formatting them to RGB-24bit
            ROMbuf.BaseStream.Seek((long)LVLPrims[ThisLevelGroup].Palletes, System.IO.SeekOrigin.Begin);
            for (i = 0; i < (64 * (TotalPalletes[ThisLevelGroup])); i++)
            {
                palleteRAW[i] = (short)((Int16Swap(ROMbuf.ReadInt16())) & (short)0x0EEE);
                work = palleteRAW[i];
                b = ((int)(work >> 8)) * 17;
                g = ((int)(work & (short)0x00F0) >> 4) * 17;
                r = (int)((work & (short)0x000F) * 17);
                pallete[i] = Color.FromArgb(255, r, g, b);  //255 -> opaque
            }

            #endregion
            #region 128 x 128 block misc code
            if (A[ThisLevelGroup][ThisLevelIndex].ROM_Compressed128 == 0)
            {
                if (LevelGroup128ptrs[ThisLevelGroup] != 0)
                {
                    ROMbuf.BaseStream.Seek(LevelGroup128ptrs[ThisLevelGroup], SeekOrigin.Begin);
                    num_of_128blocks = (Int32Swap(ROMbuf.ReadInt32()) - LevelGroup128ptrs[ThisLevelGroup]) >> 2;
                }
                else
                    num_of_128blocks = 0;

                true_num_of_128blocks = num_of_128blocks;
            }
            else
            {
                num_of_128blocks = (A[ThisLevelGroup][ThisLevelIndex].ROM_Compressed128 - LevelGroup128ptrs[ThisLevelGroup]) >> 2;
                ROMbuf.BaseStream.Seek((long)A[ThisLevelGroup][ThisLevelIndex].ROM_Compressed128 + 2, SeekOrigin.Begin);
                true_num_of_128blocks = Int16Swap(ROMbuf.ReadInt16());
                k = Int32Swap(ROMbuf.ReadInt32());
                ROMbuf.BaseStream.Seek((long)LevelGroup128ptrs[ThisLevelGroup], SeekOrigin.Begin);

                for (i = 0; i < num_of_128blocks; i++)
                {
                    l = Int32Swap(ROMbuf.ReadInt32());
                    if ((l == 0) || ((l & 0x7FFF0000) == 0x7FFF0000))
                        continue;

                    num_of_128blocks = (l - LevelGroup128ptrs[ThisLevelGroup]) >> 2;
                    break;
                }
            }
            
            ptrs_128x128 = new int[num_of_128blocks];
            map_128x128 = new short[num_of_128blocks << 8];

            ROMbuf.BaseStream.Seek((long)LevelGroup128ptrs[ThisLevelGroup], SeekOrigin.Begin);
            num_of_compressed_128_blocks = 0;

            for (i = 0, m = 0 ; i < num_of_128blocks; i++)
            {
                j = Int32Swap(ROMbuf.ReadInt32());
                if (j == 0)
                {
                    ptrs_128x128[i] = -1;
                    continue;
                }
                ptrs_128x128[i] = m;
                //Mark compressed 128x128blocks
                if ((j & 0x7FFF0000) == 0x7FFF0000)
                {
                    ptrs_128x128[i] = ptrs_128x128[i] | 0x40000000;
                    num_of_compressed_128_blocks++;
                }
                else
                    if (first_uncompressed_block_ptr == 0)
                        first_uncompressed_block_ptr = j;
                m += 0x200;
            }
            num_of_uncompressed_128_blocks = (m >> 9) - num_of_compressed_128_blocks;
            index_map_of_compressed128 = new int[num_of_compressed_128_blocks];
            index_map_of_uncompressed128 = new int[num_of_uncompressed_128_blocks];
            for (i = 0, j = 0, k = 0; i < num_of_128blocks; i++)
            {
                if (ptrs_128x128[i] == -1)
                continue;
                if (ptrs_128x128[i] > 0x3F000000)
                {
                    index_map_of_compressed128[j] = i;
                    j++;
                    continue;
                }
                index_map_of_uncompressed128[k] = i;
                k++;
            }


            secondary_decompression_buffer = new byte[4096];
            primary_decompression_buffer = new byte[32768];
            buffer_offset = 0x0FFC;
            temp0 = 0;
            i = 0;
            j = 0;
            k = 0;
            next_key_distance = 0;
            ROMbuf.BaseStream.Seek((long)A[ThisLevelGroup][ThisLevelIndex].ROM_Compressed128, SeekOrigin.Begin);
            if (ROMbuf.ReadInt16() != 0)
            {
                ROMbuf.BaseStream.Seek(6, SeekOrigin.Current);
                stored_size = Int16Swap(ROMbuf.ReadInt16());
                //progressBar1.Maximum = compressed_size + 3;
                //Reads the stream and decodes it
                while (stored_size >= 0)
                {
                    if (next_key_distance == 0)
                    {
                        key = ROMbuf.ReadByte();
                        next_key_distance = 8;
                        stored_size--;
                        //        progressBar1.Value++;
                    }

                    if ((key & 1) == 1)
                        key_bit = true;
                    else
                        key_bit = false;
                    key = (byte)(key >> 1);

                    if (key_bit)
                    {   //Direct copy
                        secondary_decompression_buffer[buffer_offset] = ROMbuf.ReadByte();
                        buffer_offset = (buffer_offset + 1) & 0x0FFF;
                        temp0++;
                        if (temp0 >= 0x1000)
                        {
                            temp0 -= 0x1000;
                            for (i = 0; i < 4096; i++)
                            {
                                primary_decompression_buffer[i + j * 4096] = secondary_decompression_buffer[(i - 4) & 0x0FFF];
                            }
                            j++;
                        }
                        stored_size--;
                        //       progressBar1.Value++;
                    }
                    else
                    {   //Decompress
                        operator_ = Int16Swap(ROMbuf.ReadInt16());
                        repeat_counter = (operator_ & 0x0F) + 3;
                        operator_offset = ((((operator_ << 4) & 0x0F00) | ((operator_ >> 8) & 0x00FF)) + 14) & 0x0FFF;
                        while (repeat_counter > 0)
                        {
                            secondary_decompression_buffer[buffer_offset] = secondary_decompression_buffer[operator_offset];
                            buffer_offset = (buffer_offset + 1) & 0x0FFF;
                            temp0++;
                            if (temp0 >= 0x1000)
                            {
                                temp0 -= 0x1000;
                                for (i = 0; i < 4096; i++)
                                {
                                    primary_decompression_buffer[i + j * 4096] = secondary_decompression_buffer[(i - 4) & 0x0FFF];
                                }
                                j++;
                            }
                            operator_offset = (operator_offset + 1) & 0x0FFF;
                            repeat_counter--;
                        }
                        stored_size -= 2;
                        //      progressBar1.Value += 2;
                    }
                    next_key_distance--;
                }
                for (i = 0; i < 4096; i++)
                {
                    primary_decompression_buffer[i + j * 4096] = secondary_decompression_buffer[(i - 4) & 0x0FFF];
                }
            }
            else
            {
                //Alternate decompression method
                ROMbuf.BaseStream.Seek(A[ThisLevelGroup][ThisLevelIndex].ROM_Compressed128 + 8, SeekOrigin.Begin);
                for (i = 0; i < num_of_compressed_128_blocks; i++)
                {
                    secondary_decompression_buffer = DecompressBlock(ROMbuf.BaseStream.Position, 0);
                    secondary_decompression_buffer.CopyTo(primary_decompression_buffer, i << 9);
                }
            }

            //copy compressed 128x128 maps from output vector
            for (i = 0; i < (num_of_compressed_128_blocks << 8); i++)
            {
                map_128x128[(i & 0xFF) + (index_map_of_compressed128[i >> 8] << 8)] = (short)((primary_decompression_buffer[i << 1] << 8) | (primary_decompression_buffer[(i << 1) + 1]));
            }
            //copy uncompressed 128x128 maps from ROM
            ROMbuf.BaseStream.Seek(first_uncompressed_block_ptr, SeekOrigin.Begin);
            for (i = 0; i < (num_of_uncompressed_128_blocks << 8); i++)
            {
                try
                {
                    map_128x128[(i & 0xFF) + (index_map_of_uncompressed128[i >> 8] << 8)] = Int16Swap(ROMbuf.ReadInt16());
                }
                catch (EndOfStreamException a)
                {
                    i--;
                    richTextBox1.Text += "Tried to read from past the end of file\n";
                    num_of_uncompressed_128_blocks = i >> 8;
                    break;
                }


            }
            first_uncompressed_block_ptr = 0;




            //32bit aRGB pixels
            Raw128x128pixels = new int[num_of_128blocks][];

            if (Blockimages == null)
                Blockimages = new Bitmap[4][];

                Blockimages[0] = new Bitmap[num_of_128blocks]; //P0
                Blockimages[1] = new Bitmap[num_of_128blocks]; //P1
                Blockimages[2] = new Bitmap[num_of_128blocks]; //P2
                Blockimages[3] = new Bitmap[num_of_128blocks]; //P3

                ThisLevelOffset = comboBox1.Items.IndexOf(comboBox1.SelectedItem);

            for (work = 0; work < 4; work++)
            {
                switch (work)
                {
                    case 3: temp3 = level[ThisLevelOffset].P3 << 6;
                        break;
                    case 2: temp3 = level[ThisLevelOffset].P2 << 6;
                        break;
                    case 1: temp3 = level[ThisLevelOffset].P1 << 6;
                        break;
                    default: temp3 = level[ThisLevelOffset].P0 << 6;
                        break;
                }
                
                for (m = 0, n = 0; m < num_of_128blocks; m++)
                {
                    k = 0;
                    if (ptrs_128x128[m] == -1)
                    {
                        n++;
                        continue;
                    }
                    Raw128x128pixels[m] = new int[128 * 128];
                    for (l = 0; l < 16; l++)
                    {
                        for (i = 0; i != (127 + 8); k++, i += 8)
                        {
                            if (i >= 128)
                            {
                                i -= 128;
                                i++;
                            }
                            if ((map_128x128[(i >> 3) + (l << 4) + (n << 8)] & 0x1000) == 0) //No V-flip
                                temp0 = Vram[((map_128x128[(i >> 3) + (l << 4) + (n << 8)] & 0x07FF) << 3) + (i & 0x07)];
                            else                                                  //V-flip this tile
                                temp0 = Vram[((map_128x128[(i >> 3) + (l << 4) + (n << 8)] & 0x07FF) << 3) + (7 - (i & 0x07))];

                            for (j = 0; j < 8; j++)
                            {
                                temp2 = (map_128x128[(i >> 3) + (l << 4) + (n << 8)] & (short)0x6000) >> 13; //pallete selection

                                if ((map_128x128[(i >> 3) + (l << 4) + (n << 8)] & 0x0800) == 0) //No H-flip
                                {
                                    temp1 = (temp0 >> 28) & 0x0F;     // color index
                                    temp0 = temp0 << 4;               // current tile
                                }
                                else                                  //H-flip 
                                {
                                    temp1 = temp0 & 0x0F;             // color index
                                    temp0 = temp0 >> 4;               // current tile
                                }

                                a = 255;
                                if (temp1 == 0 && !backgroundON)
                                    a = 0;                        //if the color index is 0, then the current pixel is transparent

                                r = (palleteRAW[temp1 + (temp2 << 4) + temp3] & 0x000F) * 18;
                                g = ((palleteRAW[temp1 + (temp2 << 4) + temp3] & 0x00F0) >> 4) * 18;
                                b = ((palleteRAW[temp1 + (temp2 << 4) + temp3] & 0x0F00) >> 8) * 18;

                                if (shadow_bit)
                                {
                                    //Shadow processing (Low plane A priority)
                                    if (((map_128x128[(i >> 3) + (l << 4) + (n << 8)] & 0x8000) != 0x8000) && foregroundON)
                                    {
                                        r = r >> 1;
                                        b = b >> 1;
                                        g = g >> 1;
                                    }
                                }
                                Raw128x128pixels[m][j + (k << 3)] = (a << 24) | (r << 16) | (g << 8) | (b);
                            }
                        }
                    }
                    n++;
                    Blockimages[work][m] = new Bitmap(128, 128, PixelFormat.Format32bppArgb);
                    bmpData = Blockimages[work][m].LockBits(rect, System.Drawing.Imaging.ImageLockMode.ReadWrite, Blockimages[work][m].PixelFormat);
                    IntPtr ptr2 = bmpData.Scan0;
                    System.Runtime.InteropServices.Marshal.Copy(Raw128x128pixels[m], 0, ptr2, 16384);
                    Blockimages[work][m].UnlockBits(bmpData);
                }
                LoadTileSet2(work);

            }
            

            #endregion
            #region specialblocks

            ptrs_SpecialBlocks = new int[256];
            SpecialBlockImages = new Bitmap[4][];
            for (i = 0; i < 4; i++)
            {
                SpecialBlockImages[i] = new Bitmap[256];
            }
            map_special = new short[256][][];
            Rectangle RectS = new Rectangle(0, 0, 8, 8);
            Rectangle RectD = new Rectangle(0, 0, 8, 8);
            if (LVLPrims[ThisLevelGroup].SpecialBlocks != 0)
            {
                ROMbuf.BaseStream.Seek(LVLPrims[ThisLevelGroup].SpecialBlocks, SeekOrigin.Begin);
                for (i = 0; i < 256; i++)
                {
                    temp0 = Int32Swap(ROMbuf.ReadInt32());
                    if (temp0 > 0x003FFFFF)
                        break;
                    ptrs_SpecialBlocks[i] = temp0;
                }
                for (k = 0; k < 4; k++)
                {
                    switch (k)
                    {
                        case 3: temp3 = level[ThisLevelOffset].P3 << 6;
                            break;
                        case 2: temp3 = level[ThisLevelOffset].P2 << 6;
                            break;
                        case 1: temp3 = level[ThisLevelOffset].P1 << 6;
                            break;
                        default: temp3 = level[ThisLevelOffset].P0 << 6;
                            break;
                    }
                    for (m = 0; m < 256; m++)
                    {
                        if (ptrs_SpecialBlocks[m] == 0)
                            break;
                        ROMbuf.BaseStream.Seek(ptrs_SpecialBlocks[m], SeekOrigin.Begin);
                        temp0 = (ROMbuf.ReadByte() & 0x0000003F);  //Width
                        temp1 = (ROMbuf.ReadByte() & 0x0000003F);  //Height


                        SpecialBlockImages[k][m] = new Bitmap(temp0 << 3, temp1 << 3, PixelFormat.Format32bppArgb);
                        map_special[m] = new short[temp1][];
                        for (i = 0; i < temp1; i++)
                        {
                            map_special[m][i] = new short[temp0];
                            RectD.Y = i << 3;
                            for (j = 0; j < temp0; j++)
                            {
                                RectD.X = j << 3;
                                map_special[m][i][j] = Int16Swap(ROMbuf.ReadInt16());
                                CopyImageRegion(CreateBitmapFromTile(map_special[m][i][j], temp3 >> 6, foregroundON), SpecialBlockImages[k][m], RectS, RectD);
                            }
                        }
                    }
                }
            }

            LoadTileSetPanel(0);
            special_block_index = 0;



            if (SecondaryBlocks.Image != null)
            {
                SecondaryBlocks.Image.Dispose();
                SecondaryBlocks.Image = SpecialBlockImages[0][0];
                SecondaryBlocks.Refresh();
            }
            

            #endregion


            FGheight = A[ThisLevelGroup][ThisLevelIndex].ROM_FGheight > A[ThisLevelGroup][ThisLevelIndex].ROM_Yviewable ? 
                A[ThisLevelGroup][ThisLevelIndex].ROM_FGheight : A[ThisLevelGroup][ThisLevelIndex].ROM_Yviewable;
            
            FGwidth = A[ThisLevelGroup][ThisLevelIndex].ROM_FGwidth > A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable ?
                A[ThisLevelGroup][ThisLevelIndex].ROM_FGwidth : A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable;

            foregroundmap = new short[FGheight][];
            FGmap_secondary = new Secondary_Layout[FGheight][];
            objmap = new byte[A[ThisLevelGroup][ThisLevelIndex].ROM_Yviewable][][];
            BGheight = A[ThisLevelGroup][ThisLevelIndex].ROM_BGheight;
            BGwidth = A[ThisLevelGroup][ThisLevelIndex].ROM_BGwidth;
            backgroundmap = new short[BGheight][];
            BGmap_secondary = new Secondary_Layout[BGheight][];
            progressBar1.Value = 0;


            //Check if the level has the compression flag (0xE5xxxxxx)
            if ((A[ThisLevelGroup][ThisLevelIndex].ROM_FGlayout & 0xFFFF0000) == 0xE5FF0000)
            {
                richTextBox1.Text += "G" + ThisLevelGroup + " - L" + ThisLevelIndex + " is compressed\n";
                #region level decompression code

                secondary_decompression_buffer = new byte[4096];
                primary_decompression_buffer = new byte[32768];
                buffer_offset = 0xFFC;
                i = 0;
                j = 0;
                next_key_distance = 0;

                ROMbuf.BaseStream.Seek((long)(A[ThisLevelGroup][ThisLevelIndex].ROM_LVheader + 56), SeekOrigin.Begin);
                stored_size = Int16Swap(ROMbuf.ReadInt16());
                progressBar1.Maximum = stored_size + 3;
                //Reads the stream and decodes it
                while (stored_size >= 0)
                {
                    if (next_key_distance == 0)
                    {
                        key = ROMbuf.ReadByte();
                        next_key_distance = 8;
                        stored_size--;
                        progressBar1.Value++;
                    }

                    if ((key & 1) == 1)
                        key_bit = true;
                    else
                        key_bit = false;
                    key = (byte)(key >> 1);

                    if (key_bit)
                    {   //Direct copy
                        secondary_decompression_buffer[buffer_offset] = ROMbuf.ReadByte();
                        buffer_offset = (buffer_offset + 1) & 0x0FFF;
                        if (buffer_offset == 0x0FFC)
                        {
                            for (i = 0; i < 4096; i++)
                            {
                                primary_decompression_buffer[i + j * 4096] = secondary_decompression_buffer[(i - 4) & 0x0FFF];
                            }
                            j++;
                        }
                        stored_size--;
                        progressBar1.Value++;
                    }
                    else
                    {   //Decompress
                        operator_ = Int16Swap(ROMbuf.ReadInt16());
                        repeat_counter = (operator_ & 0x0F) + 3;
                        operator_offset = ((((operator_ << 4) & 0x0F00) | ((operator_ >> 8) & 0x00FF)) + 14) & 0x0FFF;
                        while (repeat_counter > 0)
                        {
                            secondary_decompression_buffer[buffer_offset] = secondary_decompression_buffer[operator_offset];
                            buffer_offset = (buffer_offset + 1) & 0x0FFF;
                            if (buffer_offset == 0x0FFC)
                            {
                                for (i = 0; i < 4096; i++)
                                {
                                    primary_decompression_buffer[i + j * 4096] = secondary_decompression_buffer[(i - 4) & 0x0FFF];
                                }
                                j++;
                            }
                            operator_offset = (operator_offset + 1) & 0x0FFF;
                            repeat_counter--;
                        }
                        stored_size -= 2;
                        progressBar1.Value += 2;
                    }
                    next_key_distance--;
                }
                for (i = 0; i < 4096; i++)
                {
                    primary_decompression_buffer[i + j * 4096] = secondary_decompression_buffer[(i - 4) & 0x0FFF];
                }

                #endregion
            }
            else
            {
                richTextBox1.Text += "G" + ThisLevelGroup + " - L" + ThisLevelIndex + " is uncompressed\n";
                #region Level uncompressed
                temp0 = A[ThisLevelGroup][ThisLevelIndex].ROM_FGlayout;
                temp1 = A[ThisLevelGroup][ThisLevelIndex].ROM_BGlayout;
                temp2 = A[ThisLevelGroup][ThisLevelIndex].ROM_OBJmap;
                temp3 = A[ThisLevelGroup][ThisLevelIndex].ROM_OBJlist;
                ROMbuf.BaseStream.Seek((long)temp2 + FGheight * FGwidth * 2, SeekOrigin.Begin);
                l = 0xFFFF;
                if (temp2 + temp3 != 0)
                {
                    while ((l == 0xFFFF) && (ROMbuf.BaseStream.Position >= temp2))
                    {
                        l = Int16Swap(ROMbuf.ReadInt16());
                        ROMbuf.BaseStream.Seek((long)-4, SeekOrigin.Current);
                    }
                    //number of total bytes to read plus a margin of 32bytes
                    //k = (temp1 - temp0) + (temp2 - temp1) + (l + temp3 - temp2 + 32);
                    k = 32768;
                }
                else
                    k = (temp1 + BGheight * BGheight * 5 - temp0); //Primary BG layout (2) + Secondary BG layout (2) + Half of its size for listings

                if (temp0 != 0)
                    ROMbuf.BaseStream.Seek((long)temp0, SeekOrigin.Begin);
                else
                    if (temp2 !=0)
                        ROMbuf.BaseStream.Seek((long)temp2, SeekOrigin.Begin);

                primary_decompression_buffer = ROMbuf.ReadBytes(k);
                #endregion
            }


            #region Buffer copy code
            //Transform output complete map byte-array buffer in FG/BG/Obj array map
            if (A[ThisLevelGroup][ThisLevelIndex].ROM_FGlayout != 0)
            {
                for (i = 0; i < FGheight; i++)
                {
                    foregroundmap[i] = new short[FGwidth];
                    FGmap_secondary[i] = new Secondary_Layout[FGwidth];
                    for (j = 0; j < FGwidth; j++)
                    {
                        //FGmap_secondary[i][j] = new Secondary_Layout();
                        foregroundmap[i][j] = (short)((primary_decompression_buffer[2 * (i * FGwidth + j)] << 8) | (primary_decompression_buffer[2 * (i * FGwidth + j) + 1]));
                        if ((foregroundmap[i][j] & 0xC000) == 0x8000)
                        {
                            temp0 = FGwidth * FGheight * 2 + 2 * (i * FGwidth + j);
                            FGmap_secondary[i][j].number_of_elements = 1;
                            FGmap_secondary[i][j].overlay_map = new short[1];
                            FGmap_secondary[i][j].overlay_map[0] = (short)((primary_decompression_buffer[temp0] << 8) | primary_decompression_buffer[temp0 + 1]);
                        }
                        if ((foregroundmap[i][j] & 0xC000) == 0xC000)
                        {
                            temp0 = FGwidth * FGheight * 2 + 2 * (i * FGwidth + j);
                            temp1 = (short)((primary_decompression_buffer[temp0] << 8) | primary_decompression_buffer[temp0 + 1]);
                            temp0 = FGwidth * FGheight * 2;
                            temp0 = temp0 << 1;
                            FGmap_secondary[i][j].number_of_elements = 0;
                            FGmap_secondary[i][j].overlay_map = new short[32];
                            k = 0;
                            while (((primary_decompression_buffer[temp0 + temp1 + k] << 8) | primary_decompression_buffer[temp0 + temp1 + k + 1]) != 0xFFFF)
                            {
                                FGmap_secondary[i][j].number_of_elements++;
                                FGmap_secondary[i][j].overlay_map[k >> 1] = (short)((primary_decompression_buffer[temp0 + temp1 + k] << 8) | primary_decompression_buffer[temp0 + temp1 + k + 1]);
                                k += 2;
                            }
                        }
                    }
                }
                for (i = 0; i < BGheight; i++)
                {
                    backgroundmap[i] = new short[BGwidth];
                    BGmap_secondary[i] = new Secondary_Layout[BGwidth];
                    for (j = 0; j < BGwidth; j++)
                    {
                        temp2 = (A[ThisLevelGroup][ThisLevelIndex].ROM_BGlayout & 0x3FFFFF) - (A[ThisLevelGroup][ThisLevelIndex].ROM_FGlayout & 0x3FFFFF);
                        temp3 = temp2 + (2 * (i * BGwidth + j));
                        backgroundmap[i][j] = (short)(((short)(primary_decompression_buffer[temp3] << 8)) | (short)(primary_decompression_buffer[temp3 + 1]));
                        if ((backgroundmap[i][j] & 0xC000) == 0x8000)
                        {
                            temp0 = BGwidth * BGheight * 2 + 2 * (i * BGwidth + j);
                            BGmap_secondary[i][j].number_of_elements = 1;
                            BGmap_secondary[i][j].overlay_map = new short[1];
                            BGmap_secondary[i][j].overlay_map[0] = (short)((primary_decompression_buffer[temp0 + temp2] << 8) | primary_decompression_buffer[temp0 + temp2 + 1]);
                        }
                        if ((backgroundmap[i][j] & 0xC000) == 0xC000)
                        {
                            temp0 = BGwidth * BGheight * 2 + 2 * (i * BGwidth + j);
                            temp1 = (short)((primary_decompression_buffer[temp0 + temp2] << 8) | primary_decompression_buffer[temp0 + temp2 + 1]);
                            temp0 = BGwidth * BGheight * 2;
                            temp0 = temp0 << 1;
                            BGmap_secondary[i][j].number_of_elements = 0;
                            BGmap_secondary[i][j].overlay_map = new short[32];
                            k = 0;
                            while (((primary_decompression_buffer[temp0 + temp1 + temp2 + k] << 8) | primary_decompression_buffer[temp0 + temp1 + temp2 + k + 1]) != 0xFFFF)
                            {
                                BGmap_secondary[i][j].number_of_elements++;
                                BGmap_secondary[i][j].overlay_map[k >> 1] = (short)((primary_decompression_buffer[temp0 + temp1 + temp2 + k] << 8) | primary_decompression_buffer[temp0 + temp1 + temp2 + k + 1]);
                                k += 2;
                            }
                        }
                    }
                }

                k = (A[ThisLevelGroup][ThisLevelIndex].ROM_OBJmap & 0x003FFFFF) - (A[ThisLevelGroup][ThisLevelIndex].ROM_FGlayout & 0x003FFFFF);
                l = (A[ThisLevelGroup][ThisLevelIndex].ROM_OBJlist & 0x003FFFFF) - (A[ThisLevelGroup][ThisLevelIndex].ROM_FGlayout & 0x003FFFFF);
            }
            else
            {
                richTextBox1.Text += "G" + ThisLevelGroup + " - L" + ThisLevelIndex + " has no explicit layout defined\n";
                k = 0;
                l = (A[ThisLevelGroup][ThisLevelIndex].ROM_OBJlist & 0x003FFFFF) - (A[ThisLevelGroup][ThisLevelIndex].ROM_OBJmap & 0x003FFFFF);
            }
            if (A[ThisLevelGroup][ThisLevelIndex].ROM_OBJmap != 0)
            {
                byte[] Temp_ObjList = new byte[256];
                for (i = 0; i < A[ThisLevelGroup][ThisLevelIndex].ROM_Yviewable; i++)
                {
                    objmap[i] = new byte[A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable][];
                    #region Old Obj code
                    if (!NewObjectExtractingMethod)
                    {
                        j = 0;
                        n = 0;
                        m = 1;
                        while ((j < FGwidth) && (n < FGwidth))
                        {
                            temp0 = (primary_decompression_buffer[k + (n << 1) + (i << 1) * FGwidth] << 8) | primary_decompression_buffer[k + (n << 1) + 1 + (i << 1) * FGwidth];
                            temp1 = (primary_decompression_buffer[k + (m << 1) + (i << 1) * FGwidth] << 8) | primary_decompression_buffer[k + (m << 1) + 1 + (i << 1) * FGwidth];
                            if (temp0 == 0x0000FFFF)
                            {
                                j++;
                                m++;
                                n++;
                                continue;
                            }
                            if (temp1 == 0x0000FFFF)
                            {
                                m++;
                                continue;
                            }

                            if ((temp1 - temp0) < 0)
                            {
                                objmap[i][j % FGwidth] = new byte[24];
                                Array.Copy(primary_decompression_buffer, l + temp0, objmap[i][j % FGwidth], 0, 24);
                                break;
                            }
                            else
                                if (temp1 < 0x8000)
                                {
                                    objmap[i][j % FGwidth] = new byte[temp1 - temp0];
                                    Array.Copy(primary_decompression_buffer, l + temp0, objmap[i][j % FGwidth], 0, temp1 - temp0);
                                    n = m;

                                }
                                else
                                    break;
                            //j++;
                            j = n;
                            m++;
                        }
                    }
                    #endregion
                    #region New Obj code
                    else
                    {
                        for (j = 0; j < A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable; j++)
                        {
                            temp0 = (primary_decompression_buffer[k + (j << 1) + (i << 1) * A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable] << 8) |
                                    (primary_decompression_buffer[k + (j << 1) + (i << 1) * A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable + 1]);
                            if (temp0 == 0xFFFF)
                                continue;
                            objmap[i][j] = new byte[256];
                            Temp_ObjList[0] = primary_decompression_buffer[l + temp0];
                            m = Temp_ObjList[0];
                            n = 0;
                            while (m > 0)
                            {
                                temp1 = object_sizes[primary_decompression_buffer[l + temp0 + n + 1]];
                                if (temp1 == 0)
                                {
                                    Array.Copy(primary_decompression_buffer, l + temp0 + n + 1, Temp_ObjList, n + 1, 96);
                                    break;
                                }
                                Array.Copy(primary_decompression_buffer, l + temp0 + n + 1, Temp_ObjList, n + 1, temp1);
                                m--;
                                n += temp1;
                            }
                            Array.Copy(Temp_ObjList, objmap[i][j], n + 1);
                            Array.Resize<byte>(ref objmap[i][j], n + 1);
                        }
                    }
                    #endregion
                }
            }
            #endregion


            SelectedpictureBox.Image = null;
            PalSelection.Value = 0;
            selectedTile = 0x0C00;


            #region Reset vars after level load
            i = 0;
            j = 0;
            buffer_offset = 0xFFC;
            next_key_distance = 0;
            operator_offset = 0;
            LevelScrollBar_H.Minimum = 0;
            LevelScrollBar_H.Value = 0;
            LevelScrollBar_V.Minimum = 0;
            LevelScrollBar_V.Value = 0;
            #endregion

            LoadLevelPanel();
        }

        private void FlipVCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (SelectedpictureBox.Image != null)
            {
                SelectedpictureBox.Image.RotateFlip(RotateFlipType.RotateNoneFlipY);
                SelectedpictureBox.Refresh();
            }
        }

        private void FlipHCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (SelectedpictureBox.Image != null)
            {
                SelectedpictureBox.Image.RotateFlip(RotateFlipType.RotateNoneFlipX);
                SelectedpictureBox.Refresh();
            }
        }
        void pnlLevel_Resize(object sender, System.EventArgs e)
        {
            if (pnlLevel.Size.Width + pnlLevel.Size.Height > 0)
            {
                //redraw the viewable level section on Maximize/Restore events
                LevelScrollBar_H.Minimum = 0;
                LevelScrollBar_H.Maximum = 0;
                LevelScrollBar_V.Minimum = 0;
                LevelScrollBar_V.Maximum = 0;
                if (foregroundON)
                {
                    if ((((FGwidth + 1) << 8) - pnlLevel.Size.Width) > 0)
                        LevelScrollBar_H.Maximum = ((FGwidth + 1) << 8) - pnlLevel.Size.Width;
                    if ((((FGheight + 1) << 8) - pnlLevel.Size.Height) > 0)
                        LevelScrollBar_V.Maximum = ((FGheight + 1) << 8) - pnlLevel.Size.Height;
                }
                if (backgroundON)
                {
                    if ((((BGwidth + 1) << 8) - pnlLevel.Size.Width) > 0)
                        LevelScrollBar_H.Maximum = ((BGwidth + 1) << 8) - pnlLevel.Size.Width;
                    if ((((BGheight + 1) << 8) - pnlLevel.Size.Height) > 0)
                        LevelScrollBar_V.Maximum = ((BGheight + 1) << 8) - pnlLevel.Size.Height;
                }
                LevelScrollBar_H.Value = 0;
                LevelScrollBar_V.Value = 0;
                UpdateLevelPanel(0, 0);
            }
        }
        void Form1_Resize(object sender, System.EventArgs e)
        {
            if (Form1.ActiveForm != null)
            {
                OriginalPanelSize = new Size(Form1.ActiveForm.Size.Width - 205, Form1.ActiveForm.Size.Height - 163);
                LoadLevelPanel();
            }
        }

        private void Sonar_Click(object sender, EventArgs e)
        {
            Bitmap SonarMap;
            BitmapData bmpdata;
            int []Sonarmap;
            int RGBpixel;
            int block_offset;
            int water;
            Rectangle rect;
            Rectangle SourceR;
            Rectangle DestR;
            SonarMapPic SonarPic;

            if (foregroundON && (foregroundmap != null))
            {
                water = 0;
                rect = new Rectangle(0, 0, FGwidth << 4, FGheight << 4);
                SourceR = new Rectangle(0, 0, 24, 24);
                DestR = new Rectangle(0, 0, 24, 24);
                SonarMap = new Bitmap(FGwidth << 4, FGheight << 4, PixelFormat.Format32bppRgb);
                Sonarmap = new int[FGheight * FGwidth << 8];
                
                //Layout procssing
                for (i = 0; i < (FGheight << 4); i++)
                {
                    if ((i >> 4) >= level[comboBox1.Items.IndexOf(comboBox1.SelectedItem)].WaterLevel)
                        water = 0x00007F;
                    for (j = 0; j < (FGwidth << 4); j++)
                    {
                        if (foregroundmap[0] == null)
                            break;
                        block_offset = (foregroundmap[i >> 4][j >> 4] & 0x00FF) << 8;
                        temp0 = 0;
                        //Primary layout processing
                        if (((foregroundmap[i >> 4][j >> 4] & 0x0400) == 0x0400) || ((foregroundmap[i >> 4][j >> 4] & 0x8000) == 0x8000))
                        {
                            if ((foregroundmap[i >> 4][j >> 4] & 0x0400) == 0x0400)
                            {
                                temp0 = (map_128x128[(block_offset) + ((i & 0x000F) << 4) + (j & 0x000F)]) & 0x07FF;
                                if ((foregroundmap[i >> 4][j >> 4] & 0x0100) == 0x0100) //V-flip
                                    temp0 = (map_128x128[(block_offset) + ((15 - (i & 0x000F)) << 4) + (j & 0x000F)]) & 0x07FF;
                                if ((foregroundmap[i >> 4][j >> 4] & 0x0200) == 0x0200) //H-flip
                                    temp0 = (map_128x128[(block_offset) + ((i & 0x000F) << 4) + (15 - (j & 0x000F))]) & 0x07FF;
                                if ((foregroundmap[i >> 4][j >> 4] & 0x0300) == 0x0300) //HV-flip
                                    temp0 = (map_128x128[(block_offset) + ((15 - (i & 0x000F)) << 4) + (15 - (j & 0x000F))]) & 0x07FF;
                            }
                            //Secondary layout processing
                            for (k = 0; k < FGmap_secondary[i >> 4][j >> 4].number_of_elements; k++)
                            {
                                //Y position of the secondary block within the main 128x128 chunk
                                temp1 = (FGmap_secondary[i >> 4][j >> 4].overlay_map[k] >> 12) & 0x000F;
                                //X position ...
                                temp2 = (FGmap_secondary[i >> 4][j >> 4].overlay_map[k] >> 8) & 0x000F;
                                if ((i & 0x000F) < temp1)
                                    continue;
                                if ((j & 0x000F) < temp2)
                                    continue;
                                work = (short)((FGmap_secondary[i >> 4][j >> 4].overlay_map[k]) & 0x00FF);
                                //if X or Y bigger than the secondary block size + their current position, goto next block
                                if ((i & 0x000F) >= (map_special[work].Length + temp1))
                                    continue;
                                if ((j & 0x000F) >= (map_special[work][(i & 0x000F) - temp1].Length + temp2))
                                    continue;
                                temp0 = map_special[work][(i & 0x000F) - temp1][(j & 0x000F) - temp2] & 0x07FF;
                            }
                        }
                        if (temp0 == 0)
                            RGBpixel = 0x0000FF - water;
                        else
                            RGBpixel = 0x000000;
                        Sonarmap[j + (i * FGwidth << 4)] = RGBpixel;
                    }
                }

                //Build bitmap of Blue/Black pixels
                bmpdata = SonarMap.LockBits(rect, System.Drawing.Imaging.ImageLockMode.ReadWrite, SonarMap.PixelFormat);
                IntPtr ptr3 = bmpdata.Scan0;
                System.Runtime.InteropServices.Marshal.Copy(Sonarmap, 0, ptr3, FGheight * FGwidth << 8);
                SonarMap.UnlockBits(bmpdata);
                LoadSonarPics();

                //Object placement on top of the bitmap
                for (i = 0; i < A[ThisLevelGroup][ThisLevelIndex].ROM_Yviewable; i++)
                {
                    if(objmap[i] == null)
                        continue;
                    for (j = 0; j < A[ThisLevelGroup][ThisLevelIndex].ROM_Xviewable; j++)
                    {
                        if ((objmap[i][j] == null) || (objmap[i][j].Count() < 4))
                            continue;
                        k = 1;
                        l = 0;
                        while ((k < objmap[i][j].GetLength(0)) && (l < objmap[i][j][0]))
                        {
                            temp0 = objmap[i][j][k];
                            if (SonarImages.ContainsKey(temp0))
                            {
                                DestR.X = (j << 4) + ((objmap[i][j][k + 3] >> 4) & 0x0F) - (SonarImages[temp0].Width >> 1) + 1;
                                DestR.Y = (i << 4) + (objmap[i][j][k + 3] & 0x0F) - (SonarImages[temp0].Height >> 1) + 1;
                                CopyImageRegion(SonarImages[temp0], SonarMap, SourceR, DestR);
                            }
                            k += object_sizes[temp0];
                            l++;
                            if (object_sizes[temp0] == 0)
                            {
                                richTextBox1.Text += "Missing Obj 0x" + temp0.ToString("X").PadLeft(2, '0') + " Length, at X=0x" + j.ToString("X").PadLeft(2, '0') + " Y=0x" + i.ToString("X").PadLeft(2, '0') + "\n";
                                foreach (byte m in objmap[i][j])
                                {
                                    if (objmap[i][j].GetLength(0) > 0x40)
                                    {
                                        richTextBox1.Text += "Object list too big";
                                        break;
                                    }
                                    richTextBox1.Text += m.ToString("X").PadLeft(2, '0') + " ";
                                }
                                richTextBox1.Text += "\n";
                                break;
                            }
                        }
                    }
                }
                SonarPic = new SonarMapPic(SonarMap);
                SonarPic.ShowDialog();
            }
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {
            if (map_special != null)
            {
                if (map_special[special_block_index] != null)
                {
                    SecondaryBlocks.Image = SpecialBlockImages[0][special_block_index];
                    SecondaryBlocks.Refresh();
                }
                special_block_index = (special_block_index + 1) & 0x000000FF;
            }
        }

        private void QueryMode_CheckedChanged(object sender, EventArgs e)
        {
            if (QueryMode.Checked)
            {
                toolTip1.Active = true;
                FlipHCheckBox.Enabled = false;
                FlipVCheckBox.Enabled = false;
            }
            else
                toolTip1.Active = false;
        }

        private void PaintMode_CheckedChanged(object sender, EventArgs e)
        {
            if (PaintMode.Checked)
            {
                if (tileImages[0].ContainsKey(selectedTile))
                    SelectedpictureBox.Image = tileImages[(int)PalSelection.Value][selectedTile];
                else
                    SelectedpictureBox.Image = tileImages[0][0x0C01];
                FlipHCheckBox.Enabled = true;
                FlipVCheckBox.Enabled = true;
                FlipHCheckBox.Checked = false;
                FlipVCheckBox.Checked = false;
                PalSelection.Enabled = true;
            }
            else
                PalSelection.Enabled = false;
        }

        private void SelectMode_CheckedChanged(object sender, EventArgs e)
        {
            if (SelectMode.Checked)
            {
                FlipHCheckBox.Enabled = false;
                FlipVCheckBox.Enabled = false;
            }
        }

        private void PalSelection_ValueChanged(object sender, EventArgs e)
        {
            if(foregroundmap != null)
                LoadTileSetPanel((int)(PalSelection.Value));
        }

        private void palleteSwappingLinesToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void ObjCounter_ValueChanged(object sender, EventArgs e)
        {
            if (objmap == null)
                return;
            if (objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7] == null)
                return;
            temp0 = 1;
            temp1 = 0;
            for (i = 0; i < ObjCounter.Value; i++)
            {
                temp0 += object_sizes[objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][temp0]];
                temp1 = object_sizes[objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][temp0]];
            }
            if(ObjCounter.Value == 0)
                temp1 = object_sizes[objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][temp0]];
            for (i = 0; i < 16; i++)
            {
                if (i < temp1)
                {
                    Obj_Parameters[i].Value = objmap[ClickedLocation.Y >> 7][ClickedLocation.X >> 7][temp0 + i];
                    Obj_Parameters[i].Visible = true;
                    Parameter_Description[i].Visible = true;
                }
                else
                {
                    Obj_Parameters[i].Visible = false;
                    Parameter_Description[i].Visible = false;
                }
            }
        }
    }
}
